/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class CanvasResizeLayer
extends Layer {
    private final DesignSurface myDesignSurface;
    private final ScreenView myScreenView;
    private boolean myIsHovering;

    public CanvasResizeLayer(@NotNull DesignSurface designSurface, @NotNull ScreenView screenView) {
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
    }

    public boolean changeHovering(int x, int y) {
        boolean oldHovering = this.myIsHovering;
        Dimension size = this.myScreenView.getSize();
        Rectangle resizeZone = new Rectangle(this.myScreenView.getX() + size.width, this.myScreenView.getY() + size.height, 48, 48);
        this.myIsHovering = resizeZone.contains(x, y);
        return this.myIsHovering != oldHovering;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d) {
        if (this.myDesignSurface.getScreenMode() != DesignSurface.ScreenMode.BOTH || this.myScreenView.getScreenViewType() == ScreenView.ScreenViewType.NORMAL) {
            Dimension size = this.myScreenView.getSize();
            int x = this.myScreenView.getX();
            int y = this.myScreenView.getY();
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.setStroke(NlConstants.SOLID_STROKE);
            graphics.setColor(this.myIsHovering ? NlConstants.RESIZING_CORNER_COLOR : NlConstants.RESIZING_CUE_COLOR);
            graphics.drawLine(x + size.width + 20, y + size.height + 4, x + size.width + 4, y + size.height + 20);
            graphics.drawLine(x + size.width + 20, y + size.height + 12, x + size.width + 12, y + size.height + 20);
            graphics.dispose();
        }
    }
}

