/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagItemRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagRenderer;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class NlPropertyRenderers {
    private static NlDefaultRenderer ourDefaultRenderer;
    private static NlBooleanRenderer ourBooleanRenderer;
    private static NlFlagRenderer ourFlagRenderer;
    private static NlFlagItemRenderer ourFlagItemRenderer;

    @NotNull
    public static TableCellRenderer get(@NotNull NlProperty p) {
        NlAttributeRenderer renderer;
        AttributeDefinition definition = p.getDefinition();
        if (definition == null) {
            return NlPropertyRenderers.getDefaultRenderer();
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if (formats.size() == 1 && formats.contains((Object)AttributeFormat.Boolean) && ((NlBooleanRenderer)(renderer = NlPropertyRenderers.getBooleanRenderer())).canRender(p, formats)) {
            return renderer;
        }
        if (formats.contains((Object)AttributeFormat.Flag) && ((NlFlagRenderer)(renderer = NlPropertyRenderers.getFlagRenderer())).canRender(p, formats)) {
            return renderer;
        }
        return NlPropertyRenderers.getDefaultRenderer();
    }

    @NotNull
    public static NlFlagRenderer getFlagRenderer() {
        if (ourFlagRenderer == null) {
            ourFlagRenderer = new NlFlagRenderer();
        }
        return ourFlagRenderer;
    }

    @NotNull
    public static NlFlagItemRenderer getFlagItemRenderer() {
        if (ourFlagItemRenderer == null) {
            ourFlagItemRenderer = new NlFlagItemRenderer();
        }
        return ourFlagItemRenderer;
    }

    @NotNull
    private static NlBooleanRenderer getBooleanRenderer() {
        if (ourBooleanRenderer == null) {
            ourBooleanRenderer = new NlBooleanRenderer();
        }
        return ourBooleanRenderer;
    }

    @NotNull
    private static NlDefaultRenderer getDefaultRenderer() {
        if (ourDefaultRenderer == null) {
            ourDefaultRenderer = new NlDefaultRenderer();
        }
        return ourDefaultRenderer;
    }
}

