/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAttributeRenderer
implements TableCellRenderer,
BrowsePanel.Context {
    private final JPanel myPanel;
    private final BrowsePanel myBrowsePanel = new BrowsePanel(this);
    private JTable myTable;
    private int myRow;

    public NlAttributeRenderer() {
        this.myPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
        this.myPanel.add((Component)this.myBrowsePanel, "After");
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color bg;
        Color fg;
        assert (value instanceof NlProperty);
        assert (table instanceof PTable);
        this.myTable = table;
        this.myRow = row;
        if (isSelected) {
            fg = UIUtil.getTableSelectionForeground();
            bg = UIUtil.getTableSelectionBackground();
        } else {
            fg = UIUtil.getTableForeground();
            bg = UIUtil.getTableBackground();
        }
        this.myPanel.setForeground(fg);
        this.myPanel.setBackground(bg);
        for (int i = 0; i < this.myPanel.getComponentCount(); ++i) {
            Component comp = this.myPanel.getComponent(i);
            comp.setForeground(fg);
            comp.setBackground(bg);
        }
        boolean hover = ((PTable)((Object)table)).isHover(row, col);
        this.myBrowsePanel.setVisible(hover);
        this.customizeRenderContent(table, (NlProperty)value, isSelected, hasFocus, row, col);
        return this.myPanel;
    }

    public abstract void customizeRenderContent(@NotNull JTable var1, @NotNull NlProperty var2, boolean var3, boolean var4, int var5, int var6);

    public abstract boolean canRender(@NotNull NlProperty var1, @NotNull Set<AttributeFormat> var2);

    @Override
    @Nullable
    public NlProperty getProperty() {
        return NlTableCellEditor.getPropertyAt(this.myTable, this.myRow);
    }

    @Override
    @Nullable
    public NlProperty getDesignProperty() {
        return NlTableCellEditor.getDesignProperty(this.myTable, this.myRow);
    }

    @Override
    @Nullable
    public NlProperty getRuntimeProperty() {
        return NlTableCellEditor.getRuntimeProperty(this.myTable, this.myRow);
    }

    @Override
    public void addDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.addDesignProperty(this.myTable, this.myRow);
    }

    @Override
    public void removeDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.removeDesignProperty(this.myTable, this.myRow);
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        this.myBrowsePanel.mousePressed(event, rectRightColumn);
    }
}

