/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ptable.renderers;

import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PNameRenderer
implements TableCellRenderer {
    private final ColoredTableCellRenderer myRenderer = new Renderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        this.myRenderer.clear();
        PTableItem item = (PTableItem)value;
        this.myRenderer.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        this.myRenderer.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : table.getBackground());
        SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        SearchUtil.appendFragments((String)((PTable)((Object)table)).getSpeedSearch().getEnteredPrefix(), (String)item.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this.myRenderer);
        this.myRenderer.setToolTipText(item.getTooltipText());
        return this.myRenderer;
    }

    public static boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x) {
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = PNameRenderer.getBeforeIconSpacing(PNameRenderer.getDepth(item), icon.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            item = item.getParent();
            assert (item != null);
        }
        return result;
    }

    private static class Renderer
    extends ColoredTableCellRenderer {
        private Renderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setIcon((PTableItem)value, selected, hasFocus);
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
        }

        private void setIcon(PTableItem item, boolean selected, boolean hasFocus) {
            int textGap;
            int indent;
            Icon icon;
            Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
            int beforeGroupIcon = PNameRenderer.getBeforeIconSpacing(PNameRenderer.getDepth(item), groupIcon.getIconWidth());
            int afterGroupIcon = PNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
            if (item.hasChildren()) {
                icon = groupIcon;
                indent = beforeGroupIcon;
                textGap = afterGroupIcon;
            } else {
                icon = null;
                indent = beforeGroupIcon + groupIcon.getIconWidth() + afterGroupIcon;
                textGap = 0;
            }
            if ("http://schemas.android.com/tools".equals(item.getNamespace())) {
                if (icon == null) {
                    icon = AndroidIcons.NeleIcons.DesignProperty;
                } else {
                    LayeredIcon layered = new LayeredIcon(new Icon[]{icon, AndroidIcons.NeleIcons.DesignProperty});
                    layered.setIcon(AndroidIcons.NeleIcons.DesignProperty, 1, afterGroupIcon + icon.getIconWidth(), 0);
                    icon = layered;
                }
                textGap = 4;
            }
            this.setIcon(icon);
            this.setIconTextGap(textGap);
            this.setIpad(new Insets(0, indent, 0, 0));
        }
    }
}

