/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlFlagPropertyItemValue;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.intellij.openapi.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final JCheckBox myCheckbox;
    private final boolean myIncludeLabel;
    private NlProperty myProperty;
    private String myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        cellEditor.init(new NlFlagEditor(cellEditor, false));
        return cellEditor;
    }

    public static NlFlagEditor createForInspector(@NotNull NlEditingListener listener) {
        return new NlFlagEditor(listener, true);
    }

    private NlFlagEditor(@NotNull NlEditingListener listener, boolean includeLabel) {
        super(listener);
        this.myIncludeLabel = includeLabel;
        this.myPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
        this.myCheckbox = new JCheckBox();
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myCheckbox.addActionListener(this::actionPerformed);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        assert (property instanceof NlFlagPropertyItemValue);
        if (property != this.myProperty) {
            this.myProperty = property;
            if (this.myIncludeLabel) {
                this.myCheckbox.setText(this.myProperty.getName());
            }
        }
        this.myValue = this.myProperty.getValue();
        this.myCheckbox.setSelected("true".equalsIgnoreCase(this.myValue));
    }

    @Override
    public void activate() {
        this.myValue = "true".equalsIgnoreCase(this.myValue) ? "false" : "true";
        this.stopEditing(this.myValue);
    }

    private void actionPerformed(ActionEvent e) {
        this.myValue = this.myCheckbox.isSelected() ? "true" : "false";
        this.stopEditing(this.myValue);
    }
}

