/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.IdAnalyzer;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.Quantity;
import com.android.tools.idea.uibuilder.property.editors.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.ValueWithDisplayString;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEnumEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private static final int SMALL_WIDTH = 65;
    private static final List<String> AVAILABLE_TEXT_SIZES = ImmutableList.of((Object)"8sp", (Object)"10sp", (Object)"12sp", (Object)"14sp", (Object)"18sp", (Object)"24sp", (Object)"30sp", (Object)"36sp");
    private static final List<String> AVAILABLE_LINE_SPACINGS = AVAILABLE_TEXT_SIZES;
    private static final List<String> AVAILABLE_TYPEFACES = ImmutableList.of((Object)"normal", (Object)"sans", (Object)"serif", (Object)"monospace");
    private static final List<String> AVAILABLE_SIZES = ImmutableList.of((Object)"match_parent", (Object)"wrap_content");
    private final JPanel myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
    private final JComboBox<ValueWithDisplayString> myCombo;
    private NlProperty myProperty;
    private String myApiVersion;
    private boolean myUpdatingProperty;
    private int myAddedValueIndex = -1;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        cellEditor.init(new NlEnumEditor(cellEditor, cellEditor, false, true));
        return cellEditor;
    }

    public static NlEnumEditor createForInspector(@NotNull NlEditingListener listener) {
        return new NlEnumEditor(listener, null, true, false);
    }

    public static NlEnumEditor createForInspectorWithBrowseButton(@NotNull NlEditingListener listener) {
        return new NlEnumEditor(listener, null, true, true);
    }

    public static boolean supportsProperty(@NotNull NlProperty property) {
        switch (property.getName()) {
            case "fontFamily": 
            case "typeface": 
            case "textSize": 
            case "lineSpacingExtra": 
            case "textAppearance": 
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": 
            case "onClick": {
                return true;
            }
            case "id": {
                return false;
            }
            case "style": {
                String tagName = property.getTagName();
                return tagName != null && StyleFilter.hasWidgetStyles(property.getModel().getProject(), property.getResolver(), tagName);
            }
        }
        if (property.getName().endsWith("TextAppearance")) {
            return true;
        }
        if (AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(property.getName()) == ResourceType.ID) {
            return true;
        }
        AttributeDefinition definition = property.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        return formats.contains((Object)AttributeFormat.Enum);
    }

    private NlEnumEditor(@NotNull NlEditingListener listener, @Nullable BrowsePanel.Context context, boolean includeBorder, boolean includeBrowseButton) {
        super(listener);
        this.myCombo = new CustomComboBox(includeBorder ? this.myPanel : null);
        this.myCombo.setEditable(true);
        this.myPanel.add(this.myCombo, "Center");
        if (includeBrowseButton || context != null) {
            this.myPanel.add((Component)this.createBrowsePanel(context), "After");
        }
        this.myCombo.addActionListener(this::comboValuePicked);
        final JTextField editor = (JTextField)this.myCombo.getEditor().getEditorComponent();
        editor.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 0);
        editor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 0);
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                editor.selectAll();
            }

            @Override
            public void focusLost(FocusEvent event) {
                NlEnumEditor.this.stopEditing(NlEnumEditor.this.getText());
                editor.select(0, 0);
            }
        });
        this.myCombo.setRenderer((ListCellRenderer<ValueWithDisplayString>)((Object)new EnumRenderer()));
    }

    @Override
    public void setEnabled(boolean en) {
        this.myCombo.setEnabled(en);
        this.createBrowsePanel(null);
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property != this.myProperty || !NlEnumEditor.getApiVersion(property).equals(this.myApiVersion)) {
            this.setModel(property);
        }
        try {
            this.myUpdatingProperty = true;
            this.selectItem(ValueWithDisplayString.create(property.getValue(), property));
        }
        finally {
            this.myUpdatingProperty = false;
        }
    }

    @Override
    public void requestFocus() {
        this.myCombo.requestFocus();
    }

    private void setModel(@NotNull NlProperty property) {
        ValueWithDisplayString[] values;
        assert (NlEnumEditor.supportsProperty(property)) : this.getClass().getName() + property;
        this.myProperty = property;
        this.myApiVersion = NlEnumEditor.getApiVersion(property);
        AttributeDefinition definition = property.getDefinition();
        switch (property.getName()) {
            case "fontFamily": {
                values = ValueWithDisplayString.create(AndroidDomUtil.AVAILABLE_FAMILIES);
                break;
            }
            case "typeface": {
                values = ValueWithDisplayString.create(AVAILABLE_TYPEFACES);
                break;
            }
            case "textSize": {
                values = ValueWithDisplayString.create(AVAILABLE_TEXT_SIZES);
                break;
            }
            case "lineSpacingExtra": {
                values = ValueWithDisplayString.create(AVAILABLE_LINE_SPACINGS);
                break;
            }
            case "textAppearance": {
                values = NlEnumEditor.createTextAttributeArray(property);
                break;
            }
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": {
                values = ValueWithDisplayString.create(AVAILABLE_SIZES);
                break;
            }
            case "onClick": {
                values = NlEnumEditor.createOnClickValues(property);
                break;
            }
            case "style": {
                values = NlEnumEditor.createStyleArrayFromTag(property);
                break;
            }
            default: {
                values = property.getName().endsWith("TextAppearance") ? NlEnumEditor.createTextAttributeArray(property) : (AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(property.getName()) == ResourceType.ID ? NlEnumEditor.createChoicesForId(property) : (definition == null ? ValueWithDisplayString.EMPTY_ARRAY : ValueWithDisplayString.create(definition.getValues())));
            }
        }
        DefaultComboBoxModel<ValueWithDisplayString> newModel = new DefaultComboBoxModel<ValueWithDisplayString>(values){

            @Override
            public void setSelectedItem(Object object) {
                if (object instanceof String) {
                    String newValue = (String)object;
                    object = new ValueWithDisplayString(newValue, newValue);
                }
                super.setSelectedItem(object);
            }
        };
        newModel.insertElementAt(ValueWithDisplayString.UNSET, 0);
        this.myCombo.setModel((ComboBoxModel<ValueWithDisplayString>)newModel);
        this.myAddedValueIndex = -1;
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @NotNull
    private static String getApiVersion(@NotNull NlProperty property) {
        IAndroidTarget target = property.getModel().getConfiguration().getTarget();
        return target == null ? "24U" : target.getVersion().getApiString();
    }

    private void selectItem(@NotNull ValueWithDisplayString value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
        int index = model.getIndexOf(value);
        if (index == -1) {
            if (this.myAddedValueIndex >= 0) {
                model.removeElementAt(this.myAddedValueIndex);
            }
            this.myAddedValueIndex = this.findBestInsertionPoint(value);
            model.insertElementAt(value, this.myAddedValueIndex);
        }
        if (!value.equals(model.getSelectedItem())) {
            model.setSelectedItem(value);
        }
        if (!this.myProperty.isDefaultValue(value.getValue())) {
            this.myCombo.getEditor().getEditorComponent().setForeground((Color)CHANGED_VALUE_TEXT_COLOR);
        } else {
            this.myCombo.getEditor().getEditorComponent().setForeground((Color)DEFAULT_VALUE_TEXT_COLOR);
        }
    }

    private int findBestInsertionPoint(@NotNull ValueWithDisplayString newValue) {
        AttributeDefinition definition = this.myProperty.getDefinition();
        boolean isDimension = definition != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        int startIndex = 1;
        if (!isDimension) {
            return startIndex;
        }
        String newTextValue = newValue.toString();
        Quantity newQuantity = Quantity.parse(newTextValue);
        if (newQuantity == null) {
            return startIndex;
        }
        ComboBoxModel<ValueWithDisplayString> model = this.myCombo.getModel();
        int size = model.getSize();
        for (int index = startIndex; index < size; ++index) {
            Quantity quantity;
            String textValue = ((ValueWithDisplayString)model.getElementAt(index)).getValue();
            if (textValue == null || newQuantity.compareTo(quantity = Quantity.parse(textValue)) > 0) continue;
            return index;
        }
        return model.getSize();
    }

    @Override
    @Nullable
    public Object getValue() {
        ValueWithDisplayString value = (ValueWithDisplayString)this.myCombo.getSelectedItem();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void enter() {
        if (!this.myCombo.isPopupVisible()) {
            String newValue = this.getText();
            this.selectItem(ValueWithDisplayString.create(newValue, this.myProperty));
            this.stopEditing(newValue);
            if (this.hasFocus()) {
                this.myCombo.getEditor().selectAll();
            }
        }
        this.myCombo.hidePopup();
    }

    private void cancel() {
        String text = this.myProperty.getValue();
        if (text == null) {
            text = ValueWithDisplayString.UNSET.toString();
        }
        this.myCombo.getEditor().setItem(text);
        this.selectItem(ValueWithDisplayString.create(this.myProperty.getValue(), this.myProperty));
        this.stopEditing(this.myProperty.getValue());
        if (this.hasFocus()) {
            this.myCombo.getEditor().selectAll();
        }
        this.myCombo.hidePopup();
    }

    private boolean hasFocus() {
        if (this.myCombo.hasFocus()) {
            return true;
        }
        return this.myCombo.getEditor().getEditorComponent().hasFocus();
    }

    @Nullable
    private String getText() {
        String text = this.myCombo.getEditor().getItem().toString();
        if (StringUtil.isEmpty((String)StringUtil.trim((String)text)) || text.equals(ValueWithDisplayString.UNSET.toString())) {
            return null;
        }
        if ((text = this.addPropertyValuePrefix(text)) == null) {
            return null;
        }
        text = this.addIdPrefix(text);
        return Quantity.addUnit(this.myProperty, text);
    }

    private void comboValuePicked(ActionEvent event) {
        if (this.myUpdatingProperty || this.myProperty == null) {
            return;
        }
        ValueWithDisplayString value = (ValueWithDisplayString)this.myCombo.getModel().getSelectedItem();
        String actionCommand = event.getActionCommand();
        if (value != null && ("comboBoxEdited".equals(actionCommand) || "comboBoxChanged".equals(actionCommand))) {
            this.stopEditing(value.getValue());
        }
    }

    @Nullable
    private String addPropertyValuePrefix(@NotNull String value) {
        if (this.myProperty == null) {
            return value;
        }
        switch (this.myProperty.getName()) {
            case "style": 
            case "textAppearance": {
                break;
            }
            default: {
                if (this.myProperty.getName().endsWith("TextAppearance")) break;
                return value;
            }
        }
        if (value.startsWith("@style/") || value.startsWith("@android:style/")) {
            return value;
        }
        if ((value = this.getValueFromModel(value)) == null || value.startsWith("@style/") || value.startsWith("@android:style/")) {
            return value;
        }
        return "@style/" + value;
    }

    @NotNull
    private String addIdPrefix(@NotNull String value) {
        if (this.myProperty == null) {
            return value;
        }
        if (AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(this.myProperty.getName()) != ResourceType.ID) {
            return value;
        }
        if (value.startsWith("@+id/") || value.startsWith("@id/")) {
            return value;
        }
        return "@+id/" + value;
    }

    @Nullable
    private String getValueFromModel(@NotNull String value) {
        ValueWithDisplayString selected;
        String valueToLookup = value;
        if (valueToLookup.startsWith("TextAppearance.")) {
            valueToLookup = value.substring("TextAppearance.".length());
        }
        if ((selected = (ValueWithDisplayString)this.myCombo.getModel().getSelectedItem()) != null && valueToLookup.equals(selected.toString())) {
            value = selected.getValue();
            if (this.myProperty.isValueUnset() && this.myProperty.isDefaultValue(value)) {
                return null;
            }
            return value;
        }
        for (int index = 0; index < this.myCombo.getModel().getSize(); ++index) {
            ValueWithDisplayString item = (ValueWithDisplayString)this.myCombo.getModel().getElementAt(index);
            if (item == null || !valueToLookup.equals(item.toString())) continue;
            return item.getValue();
        }
        return value;
    }

    private static ValueWithDisplayString[] createTextAttributeArray(@NotNull NlProperty property) {
        StyleFilter checker = new StyleFilter(property.getModel().getProject(), property.getResolver());
        StyleAccumulator accumulator = new StyleAccumulator();
        checker.getStylesDerivedFrom("TextAppearance", true).forEach(accumulator::append);
        return accumulator.getValues().toArray(new ValueWithDisplayString[0]);
    }

    private static ValueWithDisplayString[] createStyleArrayFromTag(@NotNull NlProperty property) {
        String tagName = property.getTagName();
        assert (tagName != null);
        StyleFilter checker = new StyleFilter(property.getModel().getProject(), property.getResolver());
        StyleAccumulator accumulator = new StyleAccumulator();
        checker.getWidgetStyles(tagName).forEach(accumulator::append);
        return accumulator.getValues().toArray(new ValueWithDisplayString[0]);
    }

    private static ValueWithDisplayString[] createOnClickValues(@NotNull NlProperty property) {
        Collection<Object> classes;
        Module module = property.getModel().getModule();
        Configuration configuration = property.getModel().getConfiguration();
        String activityClassName = configuration.getActivity();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (activityClassName != null) {
            PsiClass aClass;
            if (activityClassName.startsWith(".")) {
                MergedManifest manifest = MergedManifest.get(module);
                String pkg = StringUtil.notNullize((String)manifest.getPackage());
                activityClassName = pkg + activityClassName;
            }
            classes = (aClass = facade.findClass(activityClassName, module.getModuleScope())) != null ? Collections.singleton(aClass) : Collections.emptyList();
        } else {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            PsiClass activity = facade.findClass("android.app.Activity", scope);
            classes = activity != null ? ClassInheritorsSearch.search((PsiClass)activity, (SearchScope)scope, (boolean)true).findAll() : Collections.emptyList();
        }
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        HashSet<String> found = new HashSet<String>();
        for (PsiClass psiClass : classes) {
            for (PsiMethod method : psiClass.getAllMethods()) {
                if (!OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method) || !found.add(method.getName()) || !(method instanceof PsiMethodImpl)) continue;
                values.add(new ValueWithDisplayString(method.getName() + " (" + psiClass.getName() + ")", method.getName()));
            }
        }
        return values.toArray(new ValueWithDisplayString[0]);
    }

    private static ValueWithDisplayString[] createChoicesForId(@NotNull NlProperty property) {
        return (ValueWithDisplayString[])IdAnalyzer.findIdsForProperty(property).stream().map(id -> new ValueWithDisplayString((String)id, "@+id/" + id)).toArray(ValueWithDisplayString[]::new);
    }

    private class EnumRenderer
    extends ColoredListCellRenderer<ValueWithDisplayString> {
        private EnumRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == ValueWithDisplayString.SEPARATOR) {
                return new JSeparator();
            }
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(JList list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                boolean isDefaultValue = NlEnumEditor.this.myProperty.isDefaultValue(value.getValue());
                if (!selected && !isDefaultValue && Objects.equals(value.getValue(), NlEnumEditor.this.getValue())) {
                    this.myForeground = NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR;
                } else if (index == 0 || isDefaultValue) {
                    this.myForeground = NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                }
                this.append(value.toString());
            }
        }
    }

    private static class StyleAccumulator {
        private final List<ValueWithDisplayString> myValues = new ArrayList<ValueWithDisplayString>();
        private StyleResourceValue myPreviousStyle;

        private StyleAccumulator() {
        }

        public void append(@NotNull StyleResourceValue style) {
            if (this.myPreviousStyle != null && (this.myPreviousStyle.isFramework() != style.isFramework() || this.myPreviousStyle.isUserDefined() != style.isUserDefined())) {
                this.myValues.add(ValueWithDisplayString.SEPARATOR);
            }
            this.myPreviousStyle = style;
            this.myValues.add(ValueWithDisplayString.createStyleValue(style.getName(), StyleAccumulator.getStylePrefix(style), null));
        }

        @NotNull
        public List<ValueWithDisplayString> getValues() {
            return this.myValues;
        }

        @NotNull
        private static String getStylePrefix(@NotNull StyleResourceValue style) {
            if (style.isFramework()) {
                return "@android:style/";
            }
            return "@style/";
        }
    }

    private static class CustomDarculaComboBoxUI
    extends DarculaComboBoxUI {
        public CustomDarculaComboBoxUI(@NotNull JComboBox comboBox) {
            super(comboBox);
        }

        protected Insets getInsets() {
            return JBUI.insets((int)2, (int)7, (int)2, (int)4).asUIResource();
        }

        @NotNull
        protected Color getArrowButtonFillColor(@NotNull Color defaultColor) {
            return JBColor.LIGHT_GRAY;
        }
    }

    private static class CustomComboBox
    extends ComboBox {
        private final JPanel myBorderPanel;
        private boolean myUseDarculaUI;

        public CustomComboBox(@Nullable JPanel borderPanel) {
            super(65);
            this.myBorderPanel = borderPanel;
            this.setBorders();
        }

        private void setBorders() {
            int horizontalSpacing;
            int n = horizontalSpacing = this.myUseDarculaUI ? 0 : 1;
            if (this.myBorderPanel != null) {
                this.myBorderPanel.setBorder(BorderFactory.createEmptyBorder(2, horizontalSpacing, 2, 0));
            }
            this.setBorder(this.myUseDarculaUI && this.myBorderPanel != null ? null : BorderFactory.createEmptyBorder(1, 4, 1, 4));
        }

        public void setUI(ComboBoxUI ui) {
            boolean bl = this.myUseDarculaUI = !(ui instanceof WindowsComboBoxUI);
            if (this.myUseDarculaUI) {
                ui = new CustomDarculaComboBoxUI((JComboBox)((Object)this));
            }
            super.setUI(ui);
            this.setBorders();
        }
    }
}

