/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.editor.NlPropertiesWindowManager;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
implements DesignSurfaceListener,
ModelListener,
LightToolWindowContent {
    public static final int UPDATE_DELAY_MSECS = 250;
    private final Project myProject;
    private final JBLoadingPanel myLoadingPanel;
    private final NlPropertiesPanel myPropertiesPanel;
    private final NlPropertyEditors myEditors;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private ScreenView myScreenView;
    @Nullable
    private List<DesignSurfaceChangedListener> mySurfaceChangedListeners;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad = true;
    private boolean myLoading;

    public NlPropertiesManager(@NotNull Project project, @Nullable DesignSurface designSurface) {
        this.myProject = project;
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project, 20);
        this.myEditors = NlPropertyEditors.getInstance(project);
        this.myPropertiesPanel = new NlPropertiesPanel(project);
        this.myLoadingPanel.add((Component)this.myPropertiesPanel);
        this.setDesignSurface(designSurface);
    }

    @NotNull
    public AnAction[] getActions() {
        return new AnAction[]{new ViewAllPropertiesAction(this.myPropertiesPanel)};
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setScreenView(null);
        } else {
            this.mySurface.addListener(this);
            ScreenView screenView = this.mySurface.getCurrentScreenView();
            this.setScreenView(screenView);
            List<NlComponent> selection = screenView != null ? screenView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
        this.notifyDesignSurfaceChanged(this.mySurface);
    }

    private void notifyDesignSurfaceChanged(@Nullable DesignSurface surface) {
        if (this.mySurfaceChangedListeners == null || this.mySurfaceChangedListeners.isEmpty()) {
            return;
        }
        for (DesignSurfaceChangedListener mySurfaceChangedListener : this.mySurfaceChangedListeners) {
            mySurfaceChangedListener.surfaceChanged(surface);
        }
    }

    public void addSurfaceChangedListener(@NotNull DesignSurfaceChangedListener listener) {
        if (this.mySurfaceChangedListeners == null) {
            this.mySurfaceChangedListeners = new ArrayList<DesignSurfaceChangedListener>(2);
        }
        this.mySurfaceChangedListeners.remove(listener);
        this.mySurfaceChangedListeners.add(listener);
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    private void setScreenView(@Nullable ScreenView screenView) {
        if (screenView == this.myScreenView) {
            return;
        }
        if (this.myScreenView != null) {
            this.myScreenView.getModel().removeListener(this);
        }
        this.myScreenView = screenView;
        if (this.myScreenView != null) {
            this.myScreenView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public NlPropertyEditors getPropertyEditors() {
        return this.myEditors;
    }

    @NotNull
    public JComponent getConfigurationPanel() {
        return this.myLoadingPanel;
    }

    @Nullable
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        return this.myUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Table<String, String, NlPropertyItem> properties = !components.isEmpty() ? NlProperties.getInstance().getProperties(components) : ImmutableTable.of();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myPropertiesPanel.setItems(components, properties, this);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            return PropertiesMap.EMPTY_MAP;
        }
        if (this.mySurface == null) {
            return PropertiesMap.EMPTY_MAP;
        }
        ScreenView view = this.mySurface.getCurrentScreenView();
        if (view == null) {
            return PropertiesMap.EMPTY_MAP;
        }
        Map<Object, PropertiesMap> map = view.getModel().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component : components) {
            PropertiesMap propertiesMap = map.get(component.getSnapshot());
            if (propertiesMap == null) {
                return PropertiesMap.EMPTY_MAP;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            return first;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property.getValue()).equals(other.get(property.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property.getKey(), property.getValue());
        }
        return commonProperties;
    }

    public void setValue(@NotNull NlProperty property, @Nullable String value) {
        property.setValue(value);
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface != this.mySurface) {
            return;
        }
        MergingUpdateQueue queue = this.getUpdateQueue();
        if (queue == null) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.myLoadingPanel.startLoading();
        }
        this.myLoading = true;
        queue.queue(new Update("updateProperties"){

            public void run() {
                NlPropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)NlPropertiesManager.this.myLoadingPanel).stopLoading());
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (!NlPropertiesWindowManager.get(this.myProject).isActivePropertiesManager(this)) {
            return false;
        }
        return this.myPropertiesPanel.activatePreferredEditor(this.myLoading);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        this.myPropertiesPanel.modelRendered(this);
    }

    public void dispose() {
        this.setDesignSurface(null);
    }

    public static interface DesignSurfaceChangedListener {
        public void surfaceChanged(@Nullable DesignSurface var1);
    }
}

