/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagPropertyItemValue
extends PTableItem
implements NlProperty {
    private final String myName;
    private final NlFlagPropertyItem myFlags;

    public NlFlagPropertyItemValue(@NotNull String name, @NotNull NlFlagPropertyItem flags) {
        this.myName = name;
        this.myFlags = flags;
        this.setParent(flags);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return null;
    }

    @Override
    public String getValue() {
        return this.myFlags.isItemSet(this) ? "true" : "false";
    }

    @Override
    public boolean isValueUnset() {
        return !this.myFlags.isItemSet(this);
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return this.getValue();
    }

    @Override
    public boolean isDefaultValue(@Nullable String value) {
        return false;
    }

    @Override
    @NotNull
    public String resolveValue(@NotNull String value) {
        return value;
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (value == null) {
            value = "false";
        }
        this.myFlags.setItem(this, "true".equalsIgnoreCase(value.toString()));
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        throw new UnsupportedOperationException(itemName);
    }

    @Override
    @NotNull
    public NlProperty getDesignTimeProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public AttributeDefinition getDefinition() {
        return this.myFlags.getDefinition();
    }

    @Override
    @NotNull
    public List<NlComponent> getComponents() {
        return this.myFlags.getComponents();
    }

    @Override
    public ResourceResolver getResolver() {
        return this.myFlags.getResolver();
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.myFlags.getModel();
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        return this.myFlags.getTag();
    }

    @Override
    @Nullable
    public String getTagName() {
        return this.myFlags.getTagName();
    }

    @Override
    @NotNull
    public TableCellRenderer getCellRenderer() {
        return NlPropertyRenderers.getFlagItemRenderer();
    }

    @Override
    public boolean isEditable(int col) {
        return true;
    }
}

