/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.ImmutableList;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.annotations.NotNull;

public class NlDesignProperties {
    private final AttributeDefinition myContextDefinition = NlDesignProperties.getDefinitionByName("context");
    private final AttributeDefinition myListItemDefinition = NlDesignProperties.getDefinitionByName("listitem");
    private final AttributeDefinition myShowInItemDefinition = NlDesignProperties.getDefinitionByName("showIn");
    private final AttributeDefinition myOpenDrawerItemDefinition = NlDesignProperties.getDefinitionByName("openDrawer");
    private final AttributeDefinition myLayoutDefinition = NlDesignProperties.getDefinitionByName("layout");
    private final AttributeDefinition myParentTagDefinition = NlDesignProperties.getDefinitionByName("parentTag");

    @NotNull
    public List<NlProperty> getKnownProperties(@NotNull List<NlComponent> components) {
        return ImmutableList.of((Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myContextDefinition), (Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myListItemDefinition), (Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myShowInItemDefinition), (Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myOpenDrawerItemDefinition), (Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myLayoutDefinition), (Object)new NlPropertyItem(components, "http://schemas.android.com/tools", this.myParentTagDefinition));
    }

    private static AttributeDefinition getDefinitionByName(@NotNull String name) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(name);
        assert (definition != null);
        ResolvingConverter converter = ToolsAttributeUtil.getConverter(definition);
        if (converter instanceof StaticEnumConverter) {
            Collection variants = converter.getVariants(null);
            for (Object variant : variants) {
                definition.addValue(variant.toString());
            }
        }
        return definition;
    }
}

