/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.TogglePaletteModeAction;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPalettePanel
extends JPanel
implements LightToolWindowContent,
ConfigurationListener,
ResourceNotificationManager.ResourceChangeListener,
LafManagerListener,
DataProvider {
    private static final Insets INSETS = new Insets(0, 6, 0, 6);
    private static final int ICON_SPACER = 4;
    private final JTree myPaletteTree = new PaletteTree();
    private final IconPreviewFactory myIconFactory = IconPreviewFactory.get();
    private final NlPaletteModel myModel;
    private final Set<String> myMissingLibraries;
    private final Disposable myDisposable;
    private final DnDManager myDndManager;
    private final DnDSource myDndSource;
    private final NlComponentTree myStructureTree;
    private DesignSurface myDesignSurface;
    private Mode myMode;
    private BufferedImage myLastDragImage;
    private Configuration myConfiguration;

    public NlPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface) {
        this.myModel = NlPaletteModel.get(project);
        this.myMissingLibraries = new HashSet<String>();
        this.myDisposable = Disposer.newDisposable();
        this.myMode = Mode.ICON_AND_TEXT;
        this.myDndManager = DnDManager.getInstance();
        this.myDndSource = new PaletteDnDSource();
        this.myDndManager.registerSource(this.myDndSource, (JComponent)this.myPaletteTree);
        this.initTree();
        JScrollPane palettePane = ScrollPaneFactory.createScrollPane((Component)this.myPaletteTree, (int)20, (int)31);
        this.myStructureTree = new NlComponentTree(designSurface);
        JComponent structurePane = NlPalettePanel.createStructurePane(this.myStructureTree);
        Splitter splitter = new Splitter(true, 0.6f);
        splitter.setFirstComponent((JComponent)palettePane);
        splitter.setSecondComponent(structurePane);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.setDesignSurface(designSurface);
    }

    @NotNull
    private static JComponent createStructurePane(@NotNull NlComponentTree structureTree) {
        JPanel panel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Component Tree");
        label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        label.setBorder(BorderFactory.createEmptyBorder(0, 5, 4, 10));
        panel.add((Component)label, "North");
        panel.add(ScrollPaneFactory.createScrollPane((Component)((Object)structureTree), (int)20, (int)31));
        return panel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.myPaletteTree;
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        Configuration configuration;
        this.myStructureTree.setDesignSurface(designSurface);
        Module prevModule = null;
        if (this.myDesignSurface != null && (configuration = this.myDesignSurface.getConfiguration()) != null) {
            prevModule = configuration.getModule();
            configuration.removeListener(this);
        }
        Module newModule = null;
        DesignSurface designSurface2 = this.myDesignSurface = designSurface != null && designSurface.getLayoutType().isSupportedByDesigner() ? designSurface : null;
        if (this.myDesignSurface != null) {
            Configuration configuration2 = this.myDesignSurface.getConfiguration();
            if (configuration2 != null) {
                newModule = configuration2.getModule();
                configuration2.addListener(this);
            }
            this.updateConfiguration();
            this.initItems();
            this.checkForNewMissingDependencies();
        }
        if (prevModule != newModule) {
            ResourceNotificationManager manager;
            AndroidFacet facet;
            if (prevModule != null && (facet = AndroidFacet.getInstance(prevModule)) != null) {
                manager = ResourceNotificationManager.getInstance(prevModule.getProject());
                manager.removeListener(this, facet, null, null);
            }
            if (newModule != null) {
                facet = AndroidFacet.getInstance(newModule);
                if (facet != null) {
                    manager = ResourceNotificationManager.getInstance(newModule.getProject());
                    manager.addListener(this, facet, null, null);
                }
                this.myIconFactory.dropCache();
            }
        }
    }

    private void updateColorsAfterColorThemeChange(boolean doUpdate) {
        LafManager manager = LafManager.getInstance();
        if (doUpdate) {
            manager.addLafManagerListener((LafManagerListener)this);
        } else {
            manager.removeLafManagerListener((LafManagerListener)this);
        }
    }

    private void setColors() {
        Color background;
        Color foreground;
        Configuration configuration = null;
        if (this.myDesignSurface != null) {
            configuration = this.myDesignSurface.getConfiguration();
        }
        ResourceResolver resolver = null;
        if (configuration != null) {
            resolver = configuration.getResourceResolver();
        }
        if (resolver == null || this.myMode != Mode.PREVIEW) {
            foreground = UIUtil.getTreeForeground();
            background = UIUtil.getTreeBackground();
        } else {
            ResourceValue textForeground;
            ResourceValue windowBackground = resolver.findItemInTheme("colorBackground", true);
            background = ResourceHelper.resolveColor((RenderResources)resolver, windowBackground, configuration.getModule().getProject());
            if (background == null) {
                background = UIUtil.getTreeBackground();
            }
            if ((foreground = ResourceHelper.resolveColor((RenderResources)resolver, textForeground = resolver.findItemInTheme("colorForeground", true), configuration.getModule().getProject())) == null) {
                foreground = UIUtil.getTreeForeground();
            }
            if (Math.abs(ImageUtils.getBrightness(background.getRGB()) - ImageUtils.getBrightness(foreground.getRGB())) < 64) {
                foreground = ImageUtils.getBrightness(background.getRGB()) < 128 ? JBColor.WHITE : JBColor.BLACK;
            }
        }
        this.myPaletteTree.setBackground(background);
        this.myPaletteTree.setForeground(foreground);
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new ActionHandler();
        }
        return null;
    }

    @NotNull
    public AnAction[] getActions() {
        return new AnAction[]{new OptionAction()};
    }

    private void showOptionPopup(@NotNull Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new TogglePaletteModeAction(this, Mode.ICON_AND_TEXT));
        group.add((AnAction)new TogglePaletteModeAction(this, Mode.PREVIEW));
        ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("ToolwindowPopup", (ActionGroup)group, (PresentationFactory)new MenuItemPresentationFactory(true));
        popupMenu.getComponent().show(component, x, y);
    }

    @NotNull
    public Mode getMode() {
        return this.myMode;
    }

    public void setMode(@NotNull Mode mode) {
        this.myMode = mode;
        this.setColors();
        this.invalidateUI();
    }

    private void updateConfiguration() {
        this.myConfiguration = null;
        if (this.myDesignSurface == null) {
            return;
        }
        Configuration designConfiguration = this.myDesignSurface.getConfiguration();
        if (designConfiguration == null) {
            return;
        }
        State designState = designConfiguration.getDeviceState();
        Configuration configuration = designConfiguration.clone();
        Device device = configuration.getDevice();
        if (device == null) {
            return;
        }
        Density override = null;
        int monitorResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        for (Density density : Density.values()) {
            if (density.getDpiValue() <= 0 || override != null && Math.abs(density.getDpiValue() - monitorResolution) >= Math.abs(override.getDpiValue() - monitorResolution)) continue;
            override = density;
        }
        if (override != null) {
            device = new Device.Builder(device).build();
            for (State state : device.getAllStates()) {
                Screen screen = state.getHardware().getScreen();
                screen.setXDimension((int)((double)(screen.getXDimension() * override.getDpiValue()) / screen.getXdpi()));
                screen.setYDimension((int)((double)(screen.getYDimension() * override.getDpiValue()) / screen.getYdpi()));
                screen.setXdpi((double)override.getDpiValue());
                screen.setYdpi((double)override.getDpiValue());
                screen.setPixelDensity(override);
            }
            configuration.setDevice(device, false);
            if (designState != null) {
                configuration.setDeviceStateName(designState.getName());
            }
            this.myConfiguration = configuration;
        }
    }

    private void invalidateUI() {
        IJSwingUtilities.updateComponentTreeUI((Component)this.myPaletteTree);
    }

    private void initTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myPaletteTree.setModel(treeModel);
        this.myPaletteTree.setRowHeight(0);
        this.myPaletteTree.getSelectionModel().setSelectionMode(1);
        this.myPaletteTree.setRootVisible(false);
        this.myPaletteTree.setShowsRootHandles(false);
        this.myPaletteTree.setBorder(new EmptyBorder(INSETS));
        this.myPaletteTree.setToggleClickCount(2);
        ToolTipManager.sharedInstance().registerComponent(this.myPaletteTree);
        TreeUtil.installActions((JTree)this.myPaletteTree);
        this.createCellRenderer(this.myPaletteTree);
        this.myPaletteTree.setSelectionRow(0);
        new PaletteSpeedSearch(this.myPaletteTree);
        this.updateColorsAfterColorThemeChange(true);
        this.enableClickToLoadMissingDependency();
    }

    private void initItems() {
        if (this.myDesignSurface == null || this.myPaletteTree.getRowCount() > 0) {
            return;
        }
        DumbService.getInstance((Project)this.myDesignSurface.getProject()).smartInvokeLater(() -> {
            if (this.myDesignSurface == null) {
                return;
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myPaletteTree.getModel().getRoot();
            NlPalettePanel.addItems(this.myModel.getPalette(this.myDesignSurface.getLayoutType()).getItems(), root);
            this.checkForNewMissingDependencies();
            NlPalettePanel.expandAll(this.myPaletteTree, root);
        });
    }

    private static void expandAll(@NotNull JTree tree, @NotNull DefaultMutableTreeNode rootNode) {
        TreePath rootPath = new TreePath(rootNode);
        tree.expandPath(rootPath);
        TreeNode child = rootNode.getLastChild();
        while (child != null) {
            tree.expandPath(rootPath.pathByAddingChild(child));
            child = rootNode.getChildBefore(child);
        }
    }

    private void createCellRenderer(@NotNull JTree tree) {
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object content = node.getUserObject();
                if (content instanceof Palette.Item) {
                    Palette.Item item = (Palette.Item)content;
                    BufferedImage image = null;
                    if (!NlPalettePanel.this.needsLibraryLoad(item) && NlPalettePanel.this.myMode == Mode.PREVIEW && NlPalettePanel.this.myConfiguration != null) {
                        image = NlPalettePanel.this.myIconFactory.getImage(item, NlPalettePanel.this.myConfiguration, NlPalettePanel.getScale(item));
                    }
                    if (image != null) {
                        this.setIcon((Icon)new JBImageIcon(image));
                        this.setToolTipText(item.getTitle());
                    } else if (NlPalettePanel.this.needsLibraryLoad(item)) {
                        Icon icon = item.getIcon();
                        Icon download = AllIcons.Actions.Download;
                        int factor = SystemInfo.isAppleJvm ? 2 : 1;
                        image = UIUtil.createImage((int)(factor * (download.getIconWidth() + icon.getIconWidth() + 4)), (int)(factor * icon.getIconHeight()), (int)2);
                        Graphics2D g2 = (Graphics2D)image.getGraphics();
                        g2.scale(factor, factor);
                        icon.paintIcon(this.myTree, g2, 0, 0);
                        download.paintIcon(this.myTree, g2, icon.getIconWidth() + 4, 0);
                        g2.dispose();
                        BufferedImage retina = ImageUtils.convertToRetina(image);
                        if (retina != null) {
                            image = retina;
                        }
                        this.append(item.getTitle());
                        this.setIcon((Icon)new JBImageIcon((Image)image));
                    } else {
                        this.append(item.getTitle());
                        this.setIcon(item.getIcon());
                    }
                } else if (content instanceof Palette.Group) {
                    Palette.Group group = (Palette.Group)content;
                    this.append(group.getName());
                    this.setIcon(AllIcons.Nodes.Folder);
                }
            }
        };
        renderer.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        tree.setCellRenderer((TreeCellRenderer)renderer);
    }

    private static double getScale(@NotNull Palette.Item item) {
        double scale = item.getPreviewScale();
        if (scale <= 0.1 || scale > 5.0) {
            scale = 1.0;
        }
        return scale;
    }

    private boolean needsLibraryLoad(@Nullable Palette.BaseItem item) {
        if (!(item instanceof Palette.Item)) {
            return false;
        }
        Palette.Item paletteItem = (Palette.Item)item;
        return this.myMissingLibraries.contains(paletteItem.getGradleCoordinate());
    }

    private static void addItems(@NotNull List<Palette.BaseItem> items, @NotNull DefaultMutableTreeNode rootNode) {
        for (Palette.BaseItem item : items) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(item);
            if (item instanceof Palette.Group) {
                Palette.Group group = (Palette.Group)item;
                NlPalettePanel.addItems(group.getItems(), node);
            }
            rootNode.add(node);
        }
    }

    private void enableClickToLoadMissingDependency() {
        this.myPaletteTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Palette.BaseItem object = NlPalettePanel.getItemForPath(NlPalettePanel.this.myPaletteTree.getPathForLocation(event.getX(), event.getY()));
                if (NlPalettePanel.this.needsLibraryLoad(object)) {
                    Palette.Item item = (Palette.Item)object;
                    String coordinate = item.getGradleCoordinate();
                    assert (coordinate != null);
                    Module module = NlPalettePanel.this.getModule();
                    assert (module != null);
                    GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
                    manager.ensureLibraryIsIncluded(module, NlPalettePanel.toGradleCoordinates(Collections.singletonList(coordinate)), null);
                }
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(ProjectEx.ProjectSaved.TOPIC, project -> {
            Module module = this.getModule();
            if (project == null || project.isDisposed() || this.myDesignSurface == null || !this.myDesignSurface.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            if (module != null && module.getProject().equals(project) && this.checkForNewMissingDependencies()) {
                this.repaint();
            }
        });
    }

    private boolean checkForNewMissingDependencies() {
        GradleDependencyManager manager;
        Module module = this.getModule();
        List<Object> missing = Collections.emptyList();
        if (module != null && (missing = NlPalettePanel.fromGradleCoordinates((manager = GradleDependencyManager.getInstance(module.getProject())).findMissingDependencies(module, this.myModel.getPalette(this.myDesignSurface.getLayoutType()).getGradleCoordinates()))).size() == this.myMissingLibraries.size() && this.myMissingLibraries.containsAll(missing)) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    @NotNull
    private static List<GradleCoordinate> toGradleCoordinates(@NotNull Collection<String> dependencies) {
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList coordinates = Lists.newArrayList();
        for (String dependency : dependencies) {
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(dependency + ":+"));
            if (coordinate == null) continue;
            coordinates.add(coordinate);
        }
        return coordinates;
    }

    @NotNull
    private static List<String> fromGradleCoordinates(@NotNull Collection<GradleCoordinate> coordinates) {
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList dependencies = Lists.newArrayList();
        for (GradleCoordinate coordinate : coordinates) {
            String dependency = coordinate.getId();
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Nullable
    private Module getModule() {
        Configuration configuration = this.myDesignSurface != null ? this.myDesignSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    @Nullable
    private static Palette.BaseItem getItemForPath(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (Palette.BaseItem)node.getUserObject();
    }

    @Override
    public boolean changed(int flags) {
        this.updateConfiguration();
        this.repaint();
        return true;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reasons) {
        for (ResourceNotificationManager.Reason reason : reasons) {
            if (reason == ResourceNotificationManager.Reason.CONFIGURATION_CHANGED) continue;
            this.myIconFactory.dropCache();
            return;
        }
    }

    public void lookAndFeelChanged(LafManager source) {
        this.setColors();
    }

    public void dispose() {
        this.setDesignSurface(null);
        this.myDndManager.unregisterSource(this.myDndSource, (JComponent)this.myPaletteTree);
        ToolTipManager.sharedInstance().unregisterComponent(this.myPaletteTree);
        this.updateColorsAfterColorThemeChange(false);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myStructureTree.dispose();
    }

    private class ActionHandler
    implements DeleteProvider,
    CutProvider,
    CopyProvider,
    PasteProvider {
        private ActionHandler() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            TreePath path = NlPalettePanel.this.myPaletteTree.getSelectionPath();
            Palette.BaseItem content = NlPalettePanel.getItemForPath(path);
            if (content instanceof Palette.Item && !NlPalettePanel.this.needsLibraryLoad(content)) {
                Palette.Item item = (Palette.Item)content;
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                CopyPasteManager.getInstance().setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            return false;
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            return false;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return false;
        }

        public void performPaste(@NotNull DataContext dataContext) {
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            return false;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            return false;
        }
    }

    private static final class PaletteSpeedSearch
    extends TreeSpeedSearch {
        PaletteSpeedSearch(@NotNull JTree tree) {
            super(tree);
        }

        protected boolean isMatchingElement(Object element, String pattern) {
            if (pattern == null) {
                return false;
            }
            TreePath path = (TreePath)element;
            Palette.BaseItem content = NlPalettePanel.getItemForPath(path);
            return content instanceof Palette.Item && this.compare(((Palette.Item)content).getTitle(), pattern);
        }
    }

    private class PaletteDnDSource
    implements DnDSource {
        private PaletteDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            Palette.BaseItem content = NlPalettePanel.getItemForPath(NlPalettePanel.this.myPaletteTree.getPathForLocation(dragOrigin.x, dragOrigin.y));
            return content instanceof Palette.Item && !NlPalettePanel.this.needsLibraryLoad(content);
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            TreePath path = NlPalettePanel.this.myPaletteTree.getClosestPathForLocation(dragOrigin.x, dragOrigin.y);
            Palette.BaseItem content = NlPalettePanel.getItemForPath(path);
            assert (content instanceof Palette.Item);
            Palette.Item item = (Palette.Item)content;
            Dimension size = null;
            if (NlPalettePanel.this.myDesignSurface != null) {
                BufferedImage image;
                ScreenView screenView = NlPalettePanel.this.myDesignSurface.getCurrentScreenView();
                BufferedImage bufferedImage = image = screenView != null ? NlPalettePanel.this.myIconFactory.renderDragImage(item, screenView) : null;
                if (image != null) {
                    size = new Dimension(image.getWidth(), image.getHeight());
                    NlPalettePanel.this.myLastDragImage = image;
                }
            }
            if (size == null) {
                Rectangle bounds = NlPalettePanel.this.myPaletteTree.getPathBounds(path);
                Dimension dimension = size = bounds != null ? bounds.getSize() : new Dimension(200, 100);
                if (NlPalettePanel.this.myDesignSurface != null) {
                    double scale = NlPalettePanel.this.myDesignSurface.getScale();
                    size.setSize(size.getWidth() / scale, size.getHeight() / scale);
                }
            }
            NlPalettePanel.this.myDesignSurface.minimizePaletteOnPreview();
            DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
            return new DnDDragStartBean((Object)new ItemTransferable(new DnDTransferItem(component)));
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            TreePath path = NlPalettePanel.this.myPaletteTree.getClosestPathForLocation(dragOrigin.x, dragOrigin.y);
            BufferedImage image = null;
            if (NlPalettePanel.this.myLastDragImage != null && NlPalettePanel.this.myDesignSurface != null) {
                double scale = NlPalettePanel.this.myDesignSurface.getScale();
                image = ImageUtils.scale(NlPalettePanel.this.myLastDragImage, scale, scale);
                NlPalettePanel.this.myLastDragImage = null;
            }
            if (image == null) {
                int row = NlPalettePanel.this.myPaletteTree.getRowForPath(path);
                Component comp = NlPalettePanel.this.myPaletteTree.getCellRenderer().getTreeCellRendererComponent(NlPalettePanel.this.myPaletteTree, path.getLastPathComponent(), false, true, true, row, false);
                comp.setForeground(NlPalettePanel.this.myPaletteTree.getForeground());
                comp.setBackground(NlPalettePanel.this.myPaletteTree.getBackground());
                comp.setFont(NlPalettePanel.this.myPaletteTree.getFont());
                comp.setSize(comp.getPreferredSize());
                image = new BufferedImage(comp.getWidth(), comp.getHeight(), 2);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
                comp.paint(g2);
                g2.dispose();
            }
            return Pair.pair((Object)image, (Object)new Point(-image.getWidth() / 2, -image.getHeight() / 2));
        }

        public void dragDropEnd() {
            NlPalettePanel.this.myPaletteTree.clearSelection();
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }

    private class PaletteTree
    extends DnDAwareTree {
        private PaletteTree() {
        }

        public void paintComponent(Graphics g) {
            if (NlPalettePanel.this.myMode == Mode.PREVIEW && NlPalettePanel.this.myDesignSurface != null && NlPalettePanel.this.myConfiguration != null && NlPalettePanel.this.myIconFactory.load(NlPalettePanel.this.myConfiguration, NlPalettePanel.this.myModel.getPalette(NlPalettePanel.this.myDesignSurface.getLayoutType()), false)) {
                NlPalettePanel.this.invalidateUI();
                return;
            }
            super.paintComponent(g);
        }
    }

    private class OptionAction
    extends AnAction {
        public OptionAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.ProjectConfigurable);
            presentation.setHoveredIcon(AllIcons.General.ProjectConfigurableBanner);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int x = 0;
            int y = 0;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            NlPalettePanel.this.showOptionPopup(inputEvent.getComponent(), x, y);
        }
    }

    public static enum Mode {
        ICON_AND_TEXT("Show Icon and Text"),
        PREVIEW("Show Preview");

        private final String myMenuText;

        private Mode(String menuText) {
            this.myMenuText = menuText;
        }

        @NotNull
        public String getMenuText() {
            return this.myMenuText;
        }
    }
}

