/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static int getSwingX(@NotNull ScreenView view, int androidX) {
        return view.getX() + (int)(view.getScale() * (double)androidX);
    }

    public static int getSwingY(@NotNull ScreenView view, int androidY) {
        return view.getY() + (int)(view.getScale() * (double)androidY);
    }

    public static int getSwingDimension(@NotNull ScreenView view, int androidDimension) {
        return (int)(view.getScale() * (double)androidDimension);
    }

    public static int getAndroidX(@NotNull ScreenView view, int swingX) {
        return (int)((double)(swingX - view.getX()) / view.getScale());
    }

    public static int getAndroidY(@NotNull ScreenView view, int swingY) {
        return (int)((double)(swingY - view.getY()) / view.getScale());
    }

    public static int getAndroidDimension(@NotNull ScreenView view, int swingDimension) {
        return (int)((double)swingDimension / view.getScale());
    }

    @Nullable
    public static NlComponent findComponent(@NotNull ScreenView view, int swingX, int swingY) {
        return view.getModel().findLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY), false);
    }

    @Nullable
    public static NlComponent findImmediateComponent(@NotNull ScreenView view, int swingX, int swingY) {
        if (view.getModel().getComponents().isEmpty()) {
            return null;
        }
        SelectionModel selectionModel = view.getSelectionModel();
        NlComponent start = null;
        start = selectionModel.isEmpty() ? view.getModel().getComponents().get(0).getRoot() : selectionModel.getPrimary();
        NlComponent found = start.findImmediateLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY));
        if (found == null) {
            found = Coordinates.findComponent(view, swingX, swingY);
        }
        return found;
    }
}

