/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintNotificationPanel
implements HyperlinkListener,
ActionListener {
    private final ScreenView myScreenView;
    private JEditorPane myExplanationPane;
    private JBList myIssueList;
    private JPanel myPanel;
    private JBLabel myPreviewLabel;
    private JBLabel myTagLabel;
    private JBCheckBox myShowIcons;
    private HtmlLinkManager myLinkManager;
    public static final String DIMENSION_KEY = "lint.notification";
    private JBPopup myPopup;

    public LintNotificationPanel(@NotNull ScreenView screenView, @NotNull LintAnnotationsModel model) {
        this.$$$setupUI$$$();
        this.myLinkManager = new HtmlLinkManager();
        this.myScreenView = screenView;
        List<LintAnnotationsModel.IssueData> issues = LintNotificationPanel.getSortedIssues(screenView, model);
        if (issues == null) {
            return;
        }
        this.myIssueList.setModel((ListModel)new CollectionListModel(issues));
        this.configureCellRenderer();
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)JBUI.scale((int)8)));
        this.myExplanationPane.setMargin((Insets)JBUI.insets((int)3, (int)3, (int)3, (int)3));
        this.myExplanationPane.setContentType("text/html");
        this.myExplanationPane.addHyperlinkListener(this);
        this.myIssueList.setSelectedIndex(0);
        this.selectIssue(issues.get(0));
        this.myIssueList.addListSelectionListener(e -> {
            Object selectedValue = this.myIssueList.getSelectedValue();
            if (!(selectedValue instanceof LintAnnotationsModel.IssueData)) {
                return;
            }
            LintAnnotationsModel.IssueData selected = (LintAnnotationsModel.IssueData)selectedValue;
            this.selectIssue(selected);
        });
        this.myPanel.setFocusable(false);
        this.myShowIcons.setSelected(AndroidEditorSettings.getInstance().getGlobalState().isShowLint());
        this.myShowIcons.addActionListener((ActionListener)this);
        ApplicationManager.getApplication().invokeLater(() -> this.myIssueList.requestFocus());
    }

    private void configureCellRenderer() {
        this.myIssueList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<LintAnnotationsModel.IssueData>(){

            protected void customizeCellRenderer(JList list, LintAnnotationsModel.IssueData value, int index, boolean selected, boolean hasFocus) {
                if (value.level == HighlightDisplayLevel.ERROR) {
                    this.append("Error: ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else if (value.level == HighlightDisplayLevel.WARNING) {
                    this.append("Warning: ");
                }
                this.append(value.message);
            }
        });
    }

    @Nullable
    private static List<LintAnnotationsModel.IssueData> getSortedIssues(@NotNull ScreenView screenView, @NotNull LintAnnotationsModel model) {
        List<LintAnnotationsModel.IssueData> issues = model.getIssues();
        if (issues.isEmpty()) {
            return null;
        }
        List<NlComponent> selection = screenView.getSelectionModel().getSelection();
        Collections.sort(issues, (o1, o2) -> {
            boolean selected2;
            boolean selected1 = selection.contains(o1.component);
            if (selected1 != (selected2 = selection.contains(o2.component))) {
                return selected1 ? -1 : 1;
            }
            int compare = -o1.level.getSeverity().compareTo(o2.level.getSeverity());
            if (compare != 0) {
                return compare;
            }
            compare = o2.issue.getPriority() - o1.issue.getPriority();
            if (compare != 0) {
                return compare;
            }
            compare = o1.issue.compareTo(o2.issue);
            if (compare != 0) {
                return compare;
            }
            compare = o1.message.compareTo(o2.message);
            if (compare != 0) {
                return compare;
            }
            return o1.startElement.getTextOffset() - o2.startElement.getTextOffset();
        });
        return issues;
    }

    private void selectIssue(@Nullable LintAnnotationsModel.IssueData selected) {
        NlComponent component = selected != null ? selected.component : null;
        this.updateIdLabel(component);
        this.updateExplanation(selected);
        this.updatePreviewImage(component);
    }

    private void updateIdLabel(@Nullable NlComponent component) {
        String text = "";
        if (component != null) {
            String id = component.getId();
            if (id != null) {
                text = id;
            } else {
                String tagName = component.getTagName();
                tagName = tagName.substring(tagName.lastIndexOf(".") + 1);
                text = "<" + tagName + ">";
            }
            ViewEditorImpl viewEditor = new ViewEditorImpl(this.myScreenView);
            text = text + " at (" + viewEditor.pxToDp(component.x) + "," + viewEditor.pxToDp(component.y) + ") dp";
        }
        this.myTagLabel.setText(text);
    }

    private void updateExplanation(@Nullable LintAnnotationsModel.IssueData selected) {
        String headerFontColor = HtmlBuilderHelper.getHeaderFontColor();
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        if (selected != null) {
            builder.addHeading("Message: ", headerFontColor);
            builder.add(selected.message).newline();
            AndroidLintInspectionBase inspection = selected.inspection;
            AndroidLintQuickFix[] quickFixes = inspection.getQuickFixes(selected.startElement, selected.endElement, selected.message);
            IntentionAction[] intentions = inspection.getIntentions(selected.startElement, selected.endElement);
            builder.addHeading("Suggested Fixes:", headerFontColor).newline();
            builder.beginList();
            for (AndroidLintQuickFix androidLintQuickFix : quickFixes) {
                builder.listItem();
                builder.addLink(androidLintQuickFix.getName(), this.myLinkManager.createRunnableLink(() -> {
                    this.myPopup.cancel();
                    WriteCommandAction.runWriteCommandAction((Project)issueData.startElement.getProject(), () -> fix.apply(issueData.startElement, issueData.endElement, AndroidQuickfixContexts.BatchContext.getInstance()));
                }));
            }
            for (AndroidLintQuickFix androidLintQuickFix : intentions) {
                builder.listItem();
                builder.addLink(androidLintQuickFix.getText(), this.myLinkManager.createRunnableLink(() -> this.lambda$updateExplanation$370(selected, (IntentionAction)androidLintQuickFix)));
            }
            SuppressLintIntentionAction suppress = new SuppressLintIntentionAction(selected.issue.getId(), selected.startElement);
            builder.listItem();
            builder.addLink(suppress.getText(), this.myLinkManager.createRunnableLink(() -> {
                this.myPopup.cancel();
                WriteCommandAction.runWriteCommandAction((Project)issueData.startElement.getProject(), () -> suppress.invoke(issueData.startElement.getProject(), null, (PsiFile)this.myScreenView.getModel().getFile()));
            }));
            builder.endList();
            Issue issue = selected.issue;
            builder.addHeading("Priority: ", headerFontColor);
            builder.addHtml(String.format("%1$d / 10", issue.getPriority()));
            builder.newline();
            builder.addHeading("Category: ", headerFontColor);
            builder.add(issue.getCategory().getFullName());
            builder.newline();
            builder.addHeading("Severity: ", headerFontColor);
            builder.beginSpan();
            HighlightDisplayLevel level = selected.level;
            builder.add(StringUtil.capitalize((String)level.getName().toLowerCase(Locale.US)));
            builder.endSpan();
            builder.newline();
            builder.addHeading("Explanation: ", headerFontColor);
            String string = issue.getBriefDescription(TextFormat.HTML);
            builder.addHtml(string);
            if (!string.isEmpty() && Character.isLetter(string.charAt(string.length() - 1))) {
                builder.addHtml(".");
            }
            builder.newline();
            String explanationHtml = issue.getExplanation(TextFormat.HTML);
            builder.addHtml(explanationHtml);
            List moreInfo = issue.getMoreInfo();
            builder.newline();
            int count = moreInfo.size();
            if (count > 1) {
                builder.addHeading("More Info: ", headerFontColor);
                builder.beginList();
            }
            for (String uri : moreInfo) {
                if (count > 1) {
                    builder.listItem();
                }
                builder.addLink(uri, uri);
            }
            if (count > 1) {
                builder.endList();
            }
            builder.newline();
        }
        builder.closeHtmlBody();
        try {
            this.myExplanationPane.read(new StringReader(builder.getHtml()), null);
            HtmlBuilderHelper.fixFontStyles(this.myExplanationPane);
            this.myExplanationPane.setCaretPosition(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updatePreviewImage(@Nullable NlComponent component) {
        if (component != null) {
            int iw = this.myPreviewLabel.getSize().width;
            int ih = this.myPreviewLabel.getSize().height;
            if (iw == 0 || ih == 0) {
                iw = 200;
                ih = 200;
            }
            BufferedImage image = new BufferedImage(iw, ih, 2);
            RenderResult renderResult = this.myScreenView.getModel().getRenderResult();
            if (renderResult != null && renderResult.getImage() != null) {
                BufferedImage fullImage = renderResult.getImage().getOriginalImage();
                Graphics2D g2d = (Graphics2D)image.getGraphics();
                int sx1 = component.x;
                int sy1 = component.y;
                int sx2 = sx1 + component.w;
                int sy2 = sy1 + component.h;
                int dx1 = 0;
                int dy1 = 0;
                int dx2 = image.getWidth();
                int dy2 = image.getHeight();
                int ex1 = 0;
                int ey1 = 0;
                int ew = image.getWidth();
                int eh = image.getHeight();
                if (component.isRoot()) {
                    int w = image.getWidth();
                    int h = image.getHeight();
                    double aspectRatio = (double)(sx2 - sx1) / (double)(sy2 - sy1);
                    if (aspectRatio >= 1.0) {
                        int newH = (int)((double)h / aspectRatio);
                        dy1 += (h - newH) / 2;
                        h = newH;
                        if (w >= sx2 - sx1) {
                            dx1 = (w - (sx2 - sx1)) / 2;
                            w = sx2 - sx1;
                            dy1 = (h - (sy2 - sy1)) / 2;
                            h = sy2 - sy1;
                        }
                    } else {
                        int newW = (int)((double)w * aspectRatio);
                        dx1 += (w - newW) / 2;
                        w = newW;
                        if (h >= sy2 - sy1) {
                            dx1 = (w - (sx2 - sx1)) / 2;
                            w = sx2 - sx1;
                            dy1 = (h - (sy2 - sy1)) / 2;
                            h = sy2 - sy1;
                        }
                    }
                    dx2 = dx1 + w;
                    dy2 = dy1 + h;
                } else {
                    double scale;
                    double aspectRatio = (double)(sx2 - sx1) / (double)(sy2 - sy1);
                    if (aspectRatio >= 1.0) {
                        int verticalPadding = (sx2 - sx1 - (sy2 - sy1)) / 2;
                        sy1 -= verticalPadding;
                        sy2 += verticalPadding;
                        scale = (double)(sx2 - sx1) / (double)(dx2 - dx1);
                        ey1 = (int)((double)verticalPadding / scale);
                        eh = (int)((double)component.h / scale);
                    } else {
                        int horizontalPadding = (sy2 - sy1 - (sx2 - sx1)) / 2;
                        sx1 -= horizontalPadding;
                        sx2 += horizontalPadding;
                        scale = (double)(sy2 - sy1) / (double)(dy2 - dy1);
                        ex1 = (int)((double)horizontalPadding / scale);
                        ew = (int)((double)component.w / scale);
                    }
                }
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.drawImage(fullImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
                if (!component.isRoot()) {
                    Area outside = new Area(new Rectangle2D.Double(0.0, 0.0, iw, ih));
                    int padding = 10;
                    Area area = new Area(new Ellipse2D.Double(ex1 - padding, ey1 - padding, ew + 2 * padding, eh + 2 * padding));
                    outside.subtract(area);
                    GraphicsConfiguration gc = g2d.getDeviceConfiguration();
                    BufferedImage img = gc.createCompatibleImage(iw, ih, 3);
                    Graphics2D g2 = img.createGraphics();
                    g2.setComposite(AlphaComposite.Clear);
                    g2.fillRect(0, 0, iw, ih);
                    g2.setComposite(AlphaComposite.Src);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(Color.WHITE);
                    g2.fill(outside);
                    g2.setComposite(AlphaComposite.SrcAtop);
                    Color background = this.myPanel.getBackground();
                    if (background == null) {
                        background = Gray._230;
                    }
                    g2.setPaint(background);
                    g2.fillRect(0, 0, iw, ih);
                    g2.dispose();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
                    g2d.drawImage((Image)img, 0, 0, null);
                }
                g2d.dispose();
            }
            this.myPreviewLabel.setIcon((Icon)new ImageIcon(image));
        } else {
            this.myPreviewLabel.setIcon(null);
        }
    }

    public void show(AnActionEvent e) {
        Object source;
        Project project = e.getProject();
        Dimension minSize = new Dimension(600, 300);
        JBPopup builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myPanel, (JComponent)this.myPanel).setProject(project).setDimensionServiceKey(project, DIMENSION_KEY, false).setResizable(true).setMovable(true).setMinSize(minSize).setRequestFocus(true).setTitle("Lint Warnings in Layout").setCancelOnClickOutside(true).setLocateWithinScreenBounds(true).setShowShadow(true).setCancelOnWindowDeactivation(true).createPopup();
        Dimension preferredSize = DimensionService.getInstance().getSize(DIMENSION_KEY, project);
        if (preferredSize == null) {
            preferredSize = this.myPanel.getPreferredSize();
        }
        if ((source = e.getInputEvent().getSource()) instanceof JComponent) {
            JComponent component = (JComponent)source;
            RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() - preferredSize.width, component.getHeight()));
            builder.show(point);
        } else {
            builder.showInBestPositionFor(e.getDataContext());
        }
        this.myPopup = builder;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
                return;
            }
            String url = e.getDescription();
            NlModel model = this.myScreenView.getModel();
            Module module = model.getModule();
            XmlFile file = model.getFile();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myScreenView.getSurface());
            assert (dataContext != null);
            this.myLinkManager.handleUrl(url, module, (PsiFile)file, dataContext, null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myShowIcons) {
            AndroidEditorSettings.getInstance().getGlobalState().setShowLint(this.myShowIcons.isSelected());
        }
    }

    private /* synthetic */ void lambda$updateExplanation$370(LintAnnotationsModel.IssueData issueData, IntentionAction intentionAction) {
        NlModel model = this.myScreenView.getModel();
        Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(issueData.startElement);
        if (editor != null) {
            editor.getCaretModel().getCurrentCaret().moveToOffset(issueData.startElement.getTextOffset());
            this.myPopup.cancel();
            WriteCommandAction.runWriteCommandAction((Project)model.getProject(), () -> intentionAction.invoke(model.getProject(), editor, (PsiFile)model.getFile()));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBList jBList;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 2, 1, 1, 7, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 1, 2, 1, 0, 3, 7, 0, null, new Dimension(200, 200), null));
        this.myExplanationPane = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        this.myPreviewLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(200, 200), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Applies To:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTagLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Issue Explanation:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 2, 0, 3, 1, 1, null, null, null));
        this.myIssueList = jBList = new JBList();
        jBScrollPane2.setViewportView((Component)jBList);
        this.myShowIcons = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show warnings or error icons on the design surface");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 2, 1, 3, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

