/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.psi.PsiElement;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    private ListMultimap<NlComponent, IssueData> myIssues;
    private List<IssueData> myIssueList;

    @NotNull
    public Collection<NlComponent> getComponentsWithIssues() {
        return this.myIssues == null ? Collections.emptyList() : this.myIssues.keySet();
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component) {
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        return HighlightDisplayLevel.ERROR.equals(max.level) ? AndroidIcons.ErrorBadge : AndroidIcons.WarningBadge;
    }

    public String getIssueMessage(@NotNull NlComponent component) {
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        return max.message + "<br><br>\n" + max.inspection.getStaticDescription();
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData, (o1, o2) -> o1.level.getSeverity().compareTo(o2.level.getSeverity()));
    }

    public void addIssue(@NotNull NlComponent component, @NotNull Issue issue, @NotNull String message, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (issue == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues == null) {
            this.myIssues = ArrayListMultimap.create();
            this.myIssueList = Lists.newArrayList();
        }
        IssueData data = new IssueData(component, inspection, issue, message, level, startElement, endElement);
        this.myIssues.put((Object)component, (Object)data);
        this.myIssueList.add(data);
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        return this.myIssueList != null ? this.myIssueList : Collections.emptyList();
    }

    static class IssueData {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final PsiElement endElement;
        @NotNull
        public final PsiElement startElement;
        @NotNull
        public final NlComponent component;

        private IssueData(@NotNull NlComponent component, @NotNull AndroidLintInspectionBase inspection, @NotNull Issue issue, @NotNull String message, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.component = component;
            this.inspection = inspection;
            this.issue = issue;
            this.message = message;
            this.level = level;
            this.startElement = startElement;
            this.endElement = endElement;
        }
    }
}

