/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.relative.Match;
import com.android.tools.idea.uibuilder.model.MarginType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RelativeDragHandler
extends GuidelineHandler {
    private int myDraggedBaseline;

    public RelativeDragHandler(@NotNull ViewEditor viewEditor, @NotNull NlComponent layout, @NotNull List<NlComponent> elements) {
        super(viewEditor, layout);
        ArrayList<NlComponent> nodes = new ArrayList<NlComponent>();
        for (NlComponent element : elements) {
            DependencyGraph.ViewData view = this.myDependencyGraph.getView(element);
            if (view == null) continue;
            nodes.add(view.node);
        }
        this.myDraggedNodes = nodes;
        this.myHorizontalDeps = this.myDependencyGraph.dependsOn(nodes, false);
        this.myVerticalDeps = this.myDependencyGraph.dependsOn(nodes, true);
        for (NlComponent child : layout.getChildren()) {
            boolean isDragged = this.myDraggedNodes.contains(child);
            if (isDragged) continue;
            String id = child.getId();
            boolean addHorizontal = !this.myHorizontalDeps.contains(child);
            boolean addVertical = !this.myVerticalDeps.contains(child);
            this.addBounds(child, id, addHorizontal, addVertical, false);
            if (!addHorizontal) continue;
            this.addBaseLine(child, id);
        }
        String id = layout.getId();
        this.addBounds(layout, id, true, true, true);
        this.addCenter(layout, id);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        int maxDistance = 20;
        if (this.myTextDirection.isLeftSegment(vEdge.edgeType)) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.myLeftMargin = margin;
            } else {
                newBounds.x = x;
            }
        } else if (this.myTextDirection.isRightSegment(vEdge.edgeType)) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.x - (x - newBounds.width));
            if (margin > maxDistance) {
                this.myRightMargin = margin;
            } else {
                newBounds.x = x - newBounds.width;
            }
        } else if (vEdge.edgeType == SegmentType.CENTER_VERTICAL) {
            newBounds.x = x - newBounds.width / 2;
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        int maxDistance = 20;
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height));
            if (margin > maxDistance) {
                this.myBottomMargin = margin;
            } else {
                newBounds.y = y - newBounds.height;
            }
        } else if (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height / 2));
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.y = y - newBounds.height / 2;
            }
        } else if (hEdge.edgeType == SegmentType.BASELINE) {
            newBounds.y = y - this.myDraggedBaseline;
        } else assert (false) : hEdge;
    }

    public void updateMove(@NotNull NlComponent primary, int offsetX, int offsetY, int modifierMask) {
        this.clearSuggestions();
        this.mySnap = (modifierMask & 1) == 0;
        Rectangle b = this.myBounds = new Rectangle(primary.x + offsetX, primary.y + offsetY, primary.w, primary.h);
        Segment edge = new Segment(b.y, b.x, RelativeDragHandler.x2(b), null, null, SegmentType.TOP, MarginType.NO_MARGIN);
        List<Match> horizontalMatches = this.findClosest(edge, this.myHorizontalEdges);
        edge = new Segment(RelativeDragHandler.y2(b), b.x, RelativeDragHandler.x2(b), null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myHorizontalEdges, horizontalMatches);
        edge = new Segment(b.x, b.y, RelativeDragHandler.y2(b), null, null, SegmentType.LEFT, MarginType.NO_MARGIN);
        List<Match> verticalMatches = this.findClosest(edge, this.myVerticalEdges);
        edge = new Segment(b.x, b.y, RelativeDragHandler.y2(b), null, null, this.myTextDirection.getLeftSegment(), MarginType.NO_MARGIN);
        this.addClosest(edge, this.myVerticalEdges, verticalMatches);
        edge = new Segment(RelativeDragHandler.x2(b), b.y, RelativeDragHandler.y2(b), null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myVerticalEdges, verticalMatches);
        edge = new Segment(RelativeDragHandler.x2(b), b.y, RelativeDragHandler.y2(b), null, null, this.myTextDirection.getRightSegment(), MarginType.NO_MARGIN);
        this.addClosest(edge, this.myVerticalEdges, verticalMatches);
        edge = new Segment(RelativeDragHandler.centerX(b), b.y, RelativeDragHandler.y2(b), null, null, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myCenterVertEdges, verticalMatches);
        edge = new Segment(RelativeDragHandler.centerY(b), b.x, RelativeDragHandler.x2(b), null, null, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myCenterHorizEdges, horizontalMatches);
        int baseline = primary.getBaseline();
        if (baseline != -1) {
            this.myDraggedBaseline = baseline;
            edge = new Segment(b.y + baseline, b.x, RelativeDragHandler.x2(b), primary, null, SegmentType.BASELINE, MarginType.NO_MARGIN);
            this.addClosest(edge, this.myHorizontalEdges, horizontalMatches);
        }
        this.myHorizontalSuggestions = horizontalMatches;
        this.myVerticalSuggestions = verticalMatches;
        this.myRightMargin = 0;
        this.myLeftMargin = 0;
        this.myBottomMargin = 0;
        this.myTopMargin = 0;
        Match match = this.pickBestMatch(this.myHorizontalSuggestions);
        if (match != null) {
            if (this.myHorizontalDeps.contains(match.edge.component)) {
                match.cycle = true;
            }
            this.myMoveTop = true;
            this.myMoveBottom = true;
            this.snapHorizontal(match.with, match.edge.at, this.myBounds);
            if (match.with.edgeType == SegmentType.TOP) {
                this.myCurrentTopMatch = match;
            } else if (match.with.edgeType == SegmentType.BOTTOM) {
                this.myCurrentBottomMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_HORIZONTAL || match.with.edgeType == SegmentType.BASELINE) : match.with.edgeType;
                this.myCurrentTopMatch = match;
            }
        }
        if ((match = this.pickBestMatch(this.myVerticalSuggestions)) != null) {
            if (this.myVerticalDeps.contains(match.edge.component)) {
                match.cycle = true;
            }
            this.myMoveLeft = true;
            this.myMoveRight = true;
            this.snapVertical(match.with, match.edge.at, this.myBounds);
            if (this.myTextDirection.isLeftSegment(match.with.edgeType)) {
                this.myCurrentLeftMatch = match;
            } else if (this.myTextDirection.isRightSegment(match.with.edgeType)) {
                this.myCurrentRightMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_VERTICAL);
                this.myCurrentLeftMatch = match;
            }
        }
        this.checkCycles();
    }
}

