/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import android.widget.ListView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.preference.ListViewScrollHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceScreenDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PreferenceScreenHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent preferenceScreen, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        return new PreferenceScreenDragHandler(editor, this, preferenceScreen, preferences, type);
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent preference) {
        if (preference.getParent() != null) {
            return null;
        }
        RenderResult result = editor.getModel().getRenderResult();
        if (result == null) {
            return null;
        }
        List<ViewInfo> rootViews = result.getRootViews();
        if (rootViews == null) {
            return null;
        }
        ViewInfo listView = PreferenceScreenHandler.findListView(rootViews);
        if (listView == null) {
            return null;
        }
        return new ListViewScrollHandler((ListView)listView.getViewObject());
    }

    @Nullable
    private static ViewInfo findListView(@NotNull Iterable<ViewInfo> rootViews) {
        for (ViewInfo rootView : rootViews) {
            ViewInfo listView = PreferenceScreenHandler.findViewWithName(rootView, "android.widget.ListView");
            if (listView == null) continue;
            return listView;
        }
        return null;
    }

    @Nullable
    private static ViewInfo findViewWithName(@NotNull ViewInfo parent, @NotNull String name) {
        if (parent.getClassName().equals(name)) {
            return parent;
        }
        for (ViewInfo child : parent.getChildren()) {
            ViewInfo view = PreferenceScreenHandler.findViewWithName(child, name);
            if (view == null) continue;
            return view;
        }
        return null;
    }
}

