/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceGroupDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PreferenceScreenDragHandler
extends PreferenceGroupDragHandler {
    PreferenceScreenDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent preferenceGroup, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor, handler, preferenceGroup, preferences, type);
    }

    @Override
    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        if (count == 0) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.myInsertIndex == -1) {
            PreferenceScreenDragHandler.drawBottom(graphics, this.getChild(count - 1));
        } else {
            graphics.drawTop(this.getChild(this.myInsertIndex));
        }
    }

    @Override
    void drawDropRecipientLines(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        if (count == 0) {
            return;
        }
        NlComponent firstPreference = this.getChild(0);
        NlComponent lastPreference = this.getChild(count - 1);
        int lastPreferenceHeight = PreferenceScreenDragHandler.getHeight(lastPreference);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.myInsertIndex != 0) {
            graphics.drawTop(firstPreference);
        }
        graphics.drawLine(firstPreference.x, firstPreference.y, lastPreference.x, lastPreference.y + lastPreferenceHeight);
        graphics.drawLine(firstPreference.x + firstPreference.w, firstPreference.y, lastPreference.x + lastPreference.w, lastPreference.y + lastPreferenceHeight);
        if (this.myInsertIndex != -1) {
            PreferenceScreenDragHandler.drawBottom(graphics, lastPreference);
        }
    }

    @Override
    void drawDropZoneLines(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        if (count == 0) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        for (int i = 1; i < count; ++i) {
            if (i == this.myInsertIndex) continue;
            graphics.drawTop(this.getChild(i));
        }
    }
}

