/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.Ranges;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PreferenceGroupDragHandler
extends DragHandler {
    final NlComponent myPreferenceGroup;
    int myInsertIndex;

    PreferenceGroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent preferenceGroup, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor, handler, preferenceGroup, preferences, type);
        this.myPreferenceGroup = preferenceGroup;
    }

    @Override
    public final void commit(int x, int y, int modifiers) {
    }

    @Override
    @Nullable
    public final String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            return message;
        }
        int count = this.myPreferenceGroup.getChildCount();
        if (count == 0) {
            this.myInsertIndex = 0;
            return null;
        }
        NlComponent lastPreference = this.getChild(count - 1);
        int lastPreferenceMidpoint = PreferenceGroupDragHandler.getMidpoint(lastPreference);
        if (Ranges.contains(lastPreference.y, lastPreferenceMidpoint, y)) {
            this.myInsertIndex = count - 1;
            return null;
        }
        if (y >= lastPreferenceMidpoint) {
            this.myInsertIndex = -1;
            return null;
        }
        for (int i = 0; i < count - 1; ++i) {
            NlComponent nextPreference;
            NlComponent preference = this.getChild(i);
            int midpoint = PreferenceGroupDragHandler.getMidpoint(preference, nextPreference = this.getChild(i + 1));
            if (Ranges.contains(preference.y, midpoint, y)) {
                this.myInsertIndex = i;
                break;
            }
            if (!Ranges.contains(midpoint, nextPreference.y, y)) continue;
            this.myInsertIndex = i + 1;
            break;
        }
        return null;
    }

    @NotNull
    final NlComponent getChild(int i) {
        NlComponent child = this.myPreferenceGroup.getChild(i);
        assert (child != null);
        return child;
    }

    private static int getMidpoint(@NotNull NlComponent preference) {
        return preference.y + PreferenceGroupDragHandler.getHeight(preference) / 2;
    }

    private static int getMidpoint(@NotNull NlComponent preference1, @NotNull NlComponent preference2) {
        return (preference1.y + preference2.y) / 2;
    }

    @Override
    public final void paint(@NotNull NlGraphics graphics) {
        this.drawDropPreviewLine(graphics);
        this.drawDropRecipientLines(graphics);
        this.drawDropZoneLines(graphics);
    }

    abstract void drawDropPreviewLine(@NotNull NlGraphics var1);

    abstract void drawDropRecipientLines(@NotNull NlGraphics var1);

    abstract void drawDropZoneLines(@NotNull NlGraphics var1);

    static void drawBottom(@NotNull NlGraphics graphics, @NotNull NlComponent preference) {
        int height = PreferenceGroupDragHandler.getHeight(preference);
        graphics.drawLine(preference.x, preference.y + height, preference.x + preference.w, preference.y + height);
    }

    static int getHeight(@NotNull NlComponent preference) {
        int height = preference.h;
        if (preference.getTagName().equals("PreferenceCategory")) {
            for (NlComponent child : preference.getChildren()) {
                height += child.h;
            }
        }
        return height;
    }

    @Override
    public final int getInsertIndex() {
        return this.myInsertIndex;
    }
}

