/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDragHandler
extends DragHandler {
    private static final String SEARCH_ICON = "ic_search_black_24dp";
    private final NlComponent myGroup;
    private final List<NlComponent> myItems;
    private final List<NlComponent> myActionBarGroup;
    private final List<NlComponent> myOverflowGroup;
    private final Rectangle myActionBarGroupBounds;
    private final Rectangle myOverflowGroupBounds;
    private NlComponent myActiveItem;

    GroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent group, @NotNull List<NlComponent> items, @NotNull DragType type) {
        super(editor, handler, group, items, type);
        assert (!items.isEmpty());
        this.myGroup = group;
        this.myItems = items;
        this.myActionBarGroup = new ArrayList<NlComponent>();
        this.myOverflowGroup = new ArrayList<NlComponent>();
        this.addToActionBarOrOverflowGroups(group);
        this.myActionBarGroup.sort((item1, item2) -> Integer.compare(item1.x, item2.x));
        this.myOverflowGroup.sort((item1, item2) -> Integer.compare(item1.y, item2.y));
        this.myActionBarGroupBounds = GroupDragHandler.getBounds(this.myActionBarGroup);
        this.myOverflowGroupBounds = GroupDragHandler.getBounds(this.myOverflowGroup);
    }

    private void addToActionBarOrOverflowGroups(@NotNull NlComponent group) {
        for (NlComponent item : group.getChildren()) {
            if (item.w == -1 || item.h == -1) continue;
            if (item.viewInfo == null) {
                this.addToActionBarOrOverflowGroups(item);
                continue;
            }
            switch (item.viewInfo.getViewType()) {
                case ACTION_BAR_MENU: {
                    this.myActionBarGroup.add(item);
                    break;
                }
                case ACTION_BAR_OVERFLOW_MENU: {
                    this.myOverflowGroup.add(item);
                    break;
                }
            }
        }
    }

    @Nullable
    private static Rectangle getBounds(@NotNull List<NlComponent> items) {
        if (items.isEmpty()) {
            return null;
        }
        NlComponent firstItem = items.get(0);
        Rectangle bounds = new Rectangle(firstItem.x, firstItem.y, firstItem.w, firstItem.h);
        items.subList(1, items.size()).forEach(item -> bounds.add(new Rectangle(item.x, item.y, item.w, item.h)));
        return bounds;
    }

    @Override
    public void commit(int x, int y, int modifiers) {
        this.possiblyCopySearchIconToMainModuleSourceSet();
        this.updateOrderInCategoryAttributes();
        this.updateShowAsActionAttribute();
    }

    private void possiblyCopySearchIconToMainModuleSourceSet() {
        if (!"@drawable/ic_search_black_24dp".equals(this.myItems.get(0).getAndroidAttribute("icon"))) {
            return;
        }
        if (this.editor.moduleContainsResource(ResourceType.DRAWABLE, SEARCH_ICON)) {
            return;
        }
        this.editor.copyVectorAssetToMainModuleSourceSet(SEARCH_ICON);
    }

    private void updateOrderInCategoryAttributes() {
        if (this.myActiveItem == null || this.myActiveItem == this.myItems.get(0)) {
            return;
        }
        Integer order = GroupDragHandler.getOrderInCategory(this.myActiveItem);
        if (order == null) {
            return;
        }
        if (this.isActionBarGroupActive()) {
            this.updateActionBarGroupOrderInCategoryAttributes(order);
        } else {
            this.updateOverflowGroupOrderInCategoryAttributes(order);
        }
    }

    private void updateActionBarGroupOrderInCategoryAttributes(int order) {
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBarGroup), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private void updateOverflowGroupOrderInCategoryAttributes(int order) {
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myOverflowGroup), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private static void incrementOrderInCategoryAttributes(@NotNull Multimap<Integer, NlComponent> orderToItemMultimap, int order) {
        Collection items = orderToItemMultimap.get((Object)order);
        if (!items.isEmpty()) {
            items.forEach(item -> item.setAndroidAttribute("orderInCategory", Integer.toString(order + 1)));
            GroupDragHandler.incrementOrderInCategoryAttributes(orderToItemMultimap, order + 1);
        }
    }

    @NotNull
    private Multimap<Integer, NlComponent> createOrderToItemMultimap(@NotNull Iterable<NlComponent> group) {
        NlComponent draggedItem = this.myItems.get(0);
        ArrayListMultimap orderToItemMultimap = ArrayListMultimap.create();
        for (NlComponent item : group) {
            Integer order;
            if (item == draggedItem || (order = GroupDragHandler.getOrderInCategory(item)) == null) continue;
            orderToItemMultimap.put((Object)order, (Object)item);
        }
        return orderToItemMultimap;
    }

    @Nullable
    private static Integer getOrderInCategory(@NotNull NlComponent item) {
        String order = item.getAndroidAttribute("orderInCategory");
        return order == null ? null : Ints.tryParse((String)order);
    }

    private void updateShowAsActionAttribute() {
        if (this.isActionBarGroupActive()) {
            this.myItems.get(0).setAttribute(this.getNamespace(), "showAsAction", "always");
        } else {
            this.myItems.get(0).removeAttribute(this.getNamespace(), "showAsAction");
        }
    }

    private String getNamespace() {
        return this.editor.getModel().isModuleDependency("com.android.support:appcompat-v7") ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            this.myActiveItem = null;
            return message;
        }
        if (this.isActionBarGroupActive()) {
            this.updateUsingActionBarGroup();
        } else if (this.isOverflowGroupActive()) {
            this.updateUsingOverflowGroup();
        } else {
            this.myActiveItem = null;
        }
        return null;
    }

    private void updateUsingActionBarGroup() {
        if (this.lastX < this.myActionBarGroup.get((int)0).x) {
            this.myActiveItem = this.myActionBarGroup.get(0);
        } else {
            Optional<NlComponent> activeItem = this.myActionBarGroup.stream().filter(item -> item.containsX(this.lastX)).findFirst();
            this.myActiveItem = activeItem.orElse(this.myActionBarGroup.get(this.myActionBarGroup.size() - 1));
        }
    }

    private void updateUsingOverflowGroup() {
        if (this.lastY < this.myOverflowGroup.get((int)0).y) {
            this.myActiveItem = this.myOverflowGroup.get(0);
        } else {
            Optional<NlComponent> activeItem = this.myOverflowGroup.stream().filter(item -> item.containsY(this.lastY)).findFirst();
            this.myActiveItem = activeItem.orElse(this.myOverflowGroup.get(this.myOverflowGroup.size() - 1));
        }
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (this.isActionBarGroupActive()) {
            this.drawActionBarGroupDropPreviewLine(graphics);
            this.drawActionBarGroupDropRecipientLines(graphics);
            this.drawActionBarGroupDropZoneLines(graphics);
        } else if (this.isOverflowGroupActive()) {
            this.drawOverflowGroupDropPreviewLine(graphics);
            this.drawOverflowGroupDropRecipientLines(graphics);
            this.drawOverflowGroupDropZoneLines(graphics);
        }
    }

    private void drawActionBarGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastX < this.myActiveItem.getMidpointX()) {
            graphics.drawLeft(this.myActiveItem);
        } else {
            graphics.drawRight(this.myActiveItem);
        }
    }

    private void drawActionBarGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTop(this.myActionBarGroupBounds);
        if (this.lastX >= this.myActionBarGroup.get(0).getMidpointX()) {
            graphics.drawLeft(this.myActionBarGroupBounds);
        }
        if (this.lastX < this.myActionBarGroup.get(this.myActionBarGroup.size() - 1).getMidpointX()) {
            graphics.drawRight(this.myActionBarGroupBounds);
        }
        graphics.drawBottom(this.myActionBarGroupBounds);
    }

    private void drawActionBarGroupDropZoneLines(@NotNull NlGraphics graphics) {
        int midpointX = this.myActiveItem.getMidpointX();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = this.myActionBarGroup.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = this.myActionBarGroup.get(i);
            if (this.myActiveItem == this.myActionBarGroup.get(i - 1)) {
                if (this.lastX >= midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastX < midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            graphics.drawLeft(item);
        }
    }

    private void drawOverflowGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastY < this.myActiveItem.getMidpointY()) {
            graphics.drawTop(this.myActiveItem);
        } else {
            graphics.drawBottom(this.myActiveItem);
        }
    }

    private void drawOverflowGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.lastY >= this.myOverflowGroup.get(0).getMidpointY()) {
            graphics.drawTop(this.myOverflowGroupBounds);
        }
        graphics.drawLeft(this.myOverflowGroupBounds);
        graphics.drawRight(this.myOverflowGroupBounds);
        if (this.lastY < this.myOverflowGroup.get(this.myOverflowGroup.size() - 1).getMidpointY()) {
            graphics.drawBottom(this.myOverflowGroupBounds);
        }
    }

    private void drawOverflowGroupDropZoneLines(@NotNull NlGraphics graphics) {
        int midpointY = this.myActiveItem.getMidpointY();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = this.myOverflowGroup.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = this.myOverflowGroup.get(i);
            if (this.myActiveItem == this.myOverflowGroup.get(i - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            graphics.drawTop(item);
        }
    }

    @Override
    public int getInsertIndex() {
        if (this.isActionBarGroupActive()) {
            return this.getInsertIndexUsingActionBarGroup();
        }
        if (this.isOverflowGroupActive()) {
            return this.getInsertIndexUsingOverflowGroup();
        }
        return -1;
    }

    private int getInsertIndexUsingActionBarGroup() {
        if (this.lastX < this.myActionBarGroupBounds.x) {
            return 0;
        }
        if (this.lastX >= this.myActionBarGroupBounds.x + this.myActionBarGroupBounds.width) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private int getInsertIndexUsingOverflowGroup() {
        if (this.lastY < this.myOverflowGroupBounds.y) {
            return 0;
        }
        if (this.lastY >= this.myOverflowGroupBounds.y + this.myOverflowGroupBounds.height) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private boolean isActionBarGroupActive() {
        return this.myActionBarGroupBounds != null && this.lastY < this.myActionBarGroupBounds.y + this.myActionBarGroupBounds.height;
    }

    private boolean isOverflowGroupActive() {
        return this.myOverflowGroupBounds != null;
    }
}

