/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.HorizontalScrollViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabLayoutHandler
extends HorizontalScrollViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"tabMode", (Object)"tabGravity", (Object)"tabContentStart", (Object)"theme", (Object)"background", (Object)"tabIndicatorColor", (Object)"tabSelectedTextColor", (Object)"tabTextAppearance");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (insertType.isCreate()) {
            NlComponent tab1 = node.createChild(editor, "android.support.design.widget.TabItem", null, InsertType.VIEW_HANDLER);
            NlComponent tab2 = node.createChild(editor, "android.support.design.widget.TabItem", null, InsertType.VIEW_HANDLER);
            NlComponent tab3 = node.createChild(editor, "android.support.design.widget.TabItem", null, InsertType.VIEW_HANDLER);
            tab1.setAndroidAttribute("text", "Left");
            tab2.setAndroidAttribute("text", "Center");
            tab3.setAndroidAttribute("text", "Right");
        }
        return true;
    }

    @Override
    public boolean acceptsChild(@NotNull NlComponent layout, @NotNull NlComponent newChild) {
        return newChild.getTagName().equals("android.support.design.widget.TabItem");
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (newChild.getAndroidAttribute("text") == null) {
            newChild.setAndroidAttribute("text", "Tab" + (layout.getChildren().size() + 1));
        }
    }
}

