/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.XmlBuilder;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingActionButtonHandler
extends ImageViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"src", (Object)"backgroundTint", (Object)"rippleColor", (Object)"tint", (Object)"fabSize", (Object)"layout_anchor", (Object)"layout_anchorGravity", (Object)"elevation");
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        XmlBuilder builder = new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").androidAttribute("clickable", true);
        if (xmlType.equals((Object)XmlType.PREVIEW_ON_PALETTE)) {
            builder.attribute("app", "elevation", "0dp");
        } else {
            builder.attribute("app", "fabSize", "mini");
        }
        return builder.endTag(tagName).toString();
    }

    @Override
    @NotNull
    public String getSampleImageSrc() {
        return "@android:drawable/ic_input_add";
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        return 0.8;
    }

    @Override
    public boolean acceptsParent(@NotNull NlComponent layout, @NotNull NlComponent newChild) {
        NlComponent appBar = FloatingActionButtonHandler.getAppBar(layout);
        if (appBar == null) {
            return super.acceptsParent(layout, newChild);
        }
        return layout == appBar.getParent();
    }

    @Nullable
    private static NlComponent getAppBar(@NotNull NlComponent component) {
        NlComponent parent = component.getParent();
        while (parent != null) {
            component = parent;
            parent = component.getParent();
        }
        if (!component.getTagName().equals("android.support.design.widget.CoordinatorLayout")) {
            return null;
        }
        for (NlComponent child : component.getChildren()) {
            if (!child.getTagName().equals("android.support.design.widget.AppBarLayout")) continue;
            return child;
        }
        return null;
    }
}

