/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.editor.NlPaletteManager;
import com.android.tools.idea.uibuilder.editor.NlPropertiesWindowManager;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightFillLayout;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends JPanel
implements DesignerEditorPanelFacade,
DataProvider {
    private final XmlFile myFile;
    private final DesignSurface mySurface;
    private final ThreeComponentsSplitter myContentSplitter;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        super(new BorderLayout());
        this.setOpaque(true);
        Project project = facet.getModule().getProject();
        this.myFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, file);
        assert (this.myFile != null) : file;
        this.mySurface = new DesignSurface(project, this);
        Disposer.register((Disposable)editor, (Disposable)this.mySurface);
        NlModel model = NlModel.create(this.mySurface, (Disposable)editor, facet, this.myFile);
        this.mySurface.setModel(model);
        this.myContentSplitter = new ThreeComponentsSplitter();
        JPanel contentPanel = new JPanel((LayoutManager)new LightFillLayout());
        JComponent toolbarComponent = this.mySurface.getActionManager().createToolbar(model);
        contentPanel.add(toolbarComponent);
        contentPanel.add(this.mySurface);
        this.myContentSplitter.setDividerWidth(0);
        this.myContentSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myContentSplitter.setInnerComponent((JComponent)contentPanel);
        this.myContentSplitter.setHonorComponentsMinimumSize(true);
        this.add((Component)this.myContentSplitter, "Center");
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void dispose() {
        NlPaletteManager.get(this.mySurface.getProject()).dispose(this);
        NlPropertiesWindowManager.get(this.mySurface.getProject()).dispose(this);
        Disposer.dispose((Disposable)this.myContentSplitter);
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public XmlFile getFile() {
        return this.myFile;
    }

    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new ActionHandler(this);
        }
        return null;
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myContentSplitter;
    }

    public static class NlConfigurationHolder
    implements ConfigurationHolder {
        @NotNull
        private final DesignSurface mySurface;

        public NlConfigurationHolder(@NotNull DesignSurface surface) {
            this.mySurface = surface;
        }

        @Override
        @Nullable
        public Configuration getConfiguration() {
            return this.mySurface.getConfiguration();
        }
    }

    private static class ActionHandler
    implements DeleteProvider,
    CutProvider,
    CopyProvider,
    PasteProvider {
        private final NlEditorPanel myEditor;

        public ActionHandler(NlEditorPanel panel) {
            this.myEditor = panel;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            ScreenView screenView = this.myEditor.getSurface().getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            CopyPasteManager.getInstance().setContents(screenView.getModel().getSelectionAsTransferable());
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            return this.hasNonEmptySelection();
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
            this.performCopy(dataContext);
            this.deleteElement(dataContext);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            return this.hasNonEmptySelection();
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            return true;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            DesignSurface surface = this.myEditor.getSurface();
            ScreenView screenView = surface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            SelectionModel selectionModel = screenView.getSelectionModel();
            NlModel model = screenView.getModel();
            model.delete(selectionModel.getSelection());
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return this.hasNonEmptySelection();
        }

        public void performPaste(@NotNull DataContext dataContext) {
            this.pasteOperation(false);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            return true;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            return this.pasteOperation(true);
        }

        private boolean hasNonEmptySelection() {
            ScreenView screenView = this.myEditor.getSurface().getCurrentScreenView();
            return screenView != null && !screenView.getSelectionModel().isEmpty();
        }

        private boolean pasteOperation(boolean checkOnly) {
            NlComponent before;
            ScreenView screenView = this.myEditor.getSurface().getCurrentScreenView();
            if (screenView == null) {
                return false;
            }
            List<NlComponent> selection = screenView.getSelectionModel().getSelection();
            if (selection.size() != 1) {
                return false;
            }
            NlComponent receiver = selection.get(0);
            NlModel model = screenView.getModel();
            ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getProject());
            ViewHandler handler = handlerManager.getHandler(receiver);
            if (handler instanceof ViewGroupHandler) {
                before = receiver.getChild(0);
            } else {
                before = receiver.getNextSibling();
                if ((receiver = receiver.getParent()) == null) {
                    return false;
                }
            }
            DnDTransferItem item = ActionHandler.getClipboardData();
            if (item == null) {
                return false;
            }
            InsertType insertType = model.determineInsertType(DragType.PASTE, item, checkOnly);
            List<NlComponent> pasted = model.createComponents(screenView, item, insertType);
            if (!model.canAddComponents(pasted, receiver, before)) {
                return false;
            }
            if (checkOnly) {
                return true;
            }
            model.addComponents(pasted, receiver, before, insertType);
            return true;
        }

        @Nullable
        private static DnDTransferItem getClipboardData() {
            try {
                Object data = CopyPasteManager.getInstance().getContents(ItemTransferable.DESIGNER_FLAVOR);
                if (!(data instanceof DnDTransferItem)) {
                    return null;
                }
                return (DnDTransferItem)data;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

