/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import java.awt.Dimension;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewEditor {
    public abstract int getDpi();

    public int dpToPx(int dp) {
        int dpi = this.getDpi();
        return dp * dpi / 160;
    }

    public int pxToDp(int px) {
        int dpi = this.getDpi();
        return px * 160 / dpi;
    }

    @NotNull
    public String pxToDpWithUnits(int px) {
        return String.format(Locale.US, "%ddp", this.pxToDp(px));
    }

    @Nullable
    public abstract AndroidVersion getCompileSdkVersion();

    @NotNull
    public abstract AndroidVersion getMinSdkVersion();

    @NotNull
    public abstract AndroidVersion getTargetSdkVersion();

    @NotNull
    public abstract Configuration getConfiguration();

    @NotNull
    public abstract NlModel getModel();

    public abstract boolean moduleContainsResource(@NotNull ResourceType var1, @NotNull String var2);

    public abstract void copyVectorAssetToMainModuleSourceSet(@NotNull String var1);

    @Nullable
    public abstract Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent var1, @Nullable RenderTask.AttributeFilter var2);

    @Nullable
    public final String displayResourceInput(@NotNull EnumSet<ResourceType> types) {
        return this.displayResourceInput("", types);
    }

    @Nullable
    public abstract String displayResourceInput(@NotNull String var1, @NotNull EnumSet<ResourceType> var2);

    @Nullable
    public abstract String displayClassInput(@NotNull Set<String> var1, @Nullable Predicate<String> var2, @Nullable String var3);
}

