/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeHandler {
    @NotNull
    protected final ViewEditor editor;
    @NotNull
    protected final ViewGroupHandler handler;
    @NotNull
    protected final NlComponent layout;
    @NotNull
    protected final NlComponent component;
    protected int startX;
    protected int startY;
    protected int lastX;
    protected int lastY;
    protected int lastModifiers;
    public SegmentType horizontalEdgeType;
    public SegmentType verticalEdgeType;

    protected ResizeHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        this.editor = editor;
        this.handler = handler;
        NlComponent parent = component.getParent();
        assert (parent != null) : component;
        this.layout = parent;
        this.component = component;
        this.horizontalEdgeType = horizontalEdgeType;
        this.verticalEdgeType = verticalEdgeType;
    }

    public void cancel() {
    }

    public abstract void commit(int var1, int var2, int var3, @NotNull Rectangle var4);

    public void start(int x, int y, int modifiers) {
        this.startX = x;
        this.startY = y;
        this.lastX = x;
        this.lastY = y;
        this.lastModifiers = modifiers;
    }

    @Nullable
    public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
        this.lastX = x;
        this.lastY = y;
        this.lastModifiers = modifiers;
        return null;
    }

    public abstract void paint(@NotNull NlGraphics var1);
}

