/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionToolProvider;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeConstraintLayoutFix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Module module = AndroidPsiUtils.getModuleSafely(startElement);
        UpgradeConstraintLayoutFix.apply(module);
    }

    public static void apply(@Nullable Module module) {
        if (module != null) {
            GradleCoordinate gc;
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintInspectionToolProvider.AndroidLintMissingConstraintsInspection.class);
            RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)ConstraintLayoutDetector.LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, (ProgressIndicator)progress);
            if (p != null && (gc = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
                GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
                manager.updateLibrariesToVersion(module, Collections.singletonList(gc), null);
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Upgrade to recommended version";
    }
}

