/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectParentAction
extends AnAction {
    private final DesignSurface mySurface;

    public SelectParentAction(@NotNull DesignSurface surface) {
        super("Select Parent", "Select Parent", null);
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        List<NlComponent> selection;
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        boolean enabled = screenView != null ? (selection = screenView.getSelectionModel().getSelection()).size() == 1 && !selection.get(0).isRoot() : false;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView != null) {
            NlComponent first;
            NlComponent parent;
            SelectionModel selectionModel = screenView.getSelectionModel();
            List<NlComponent> selection = selectionModel.getSelection();
            if (selection.size() == 1 && (parent = (first = selection.get(0)).getParent()) != null) {
                selectionModel.setSelection(Collections.singletonList(parent));
            }
            this.mySurface.repaint();
        }
    }
}

