/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.FontUtil;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTablePanel
implements HyperlinkListener {
    private final ChooseResourceDialog myDialog;
    private HyperlinkLabel myEditTranslationsLink;
    private JBLabel myNameLabel;
    private JBTable myTable;
    private JPanel myPanel;
    private JBScrollPane myScrollPane;

    public ResourceTablePanel(@NotNull ChooseResourceDialog dialog) {
        this.myDialog = dialog;
        this.$$$setupUI$$$();
        this.myTable.setTableHeader(null);
        this.myTable.setBackground(UIUtil.getLabelBackground());
        this.myTable.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.getViewport().setBorder(null);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        this.myTable.setName("valueTable");
        TableSpeedSearch speedSearch = new TableSpeedSearch((JTable)this.myTable);
        speedSearch.setClearSearchOnNavigateNoMatch(true);
    }

    private void createUIComponents() {
        this.myEditTranslationsLink = new HyperlinkLabel("EDIT TRANSLATIONS");
        this.myEditTranslationsLink.addHyperlinkListener((HyperlinkListener)this);
        this.myEditTranslationsLink.setVisible(false);
    }

    @NotNull
    public JPanel getPanel() {
        return this.myPanel;
    }

    public void select(@Nullable ResourceChooserItem item) {
        if (item != null) {
            this.myTable.setModel((TableModel)new ResourceTableModel(item));
            TableColumn valueColumn = this.myTable.getColumnModel().getColumn(1);
            valueColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (column == 1) {
                        String s = value.toString();
                        component.setFont(FontUtil.getFontAbleToDisplay(s, table.getFont()));
                    } else {
                        component.setFont(table.getFont());
                    }
                    return component;
                }
            });
            this.myNameLabel.setText(item.getName());
            this.myTable.setRowHeight(ChooseResourceDialog.TABLE_CELL_HEIGHT);
            this.myEditTranslationsLink.setVisible(item.getType() == ResourceType.STRING && !item.isFramework());
        } else {
            this.myNameLabel.setText("");
            this.myTable.setModel((TableModel)new DefaultTableModel(0, 2));
            this.myEditTranslationsLink.setVisible(false);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.myDialog.close(1);
        StringResourceEditorProvider.openEditor(this.myDialog.getModule());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(12, 12, 11, 11), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.myTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
        HyperlinkLabel hyperlinkLabel = this.myEditTranslationsLink;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ResourceTableModel
    extends AbstractTableModel {
        private final List<Pair<FolderConfiguration, String>> myPairs;
        private final ResourceChooserItem myItem;

        public ResourceTableModel(@NotNull ResourceChooserItem item) {
            this.myItem = item;
            this.myPairs = item.getQualifiersAndValues();
        }

        @Override
        public int getRowCount() {
            return this.myPairs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String language;
            LocaleQualifier locale;
            Pair<FolderConfiguration, String> pair = this.myPairs.get(rowIndex);
            if (columnIndex == 1) {
                return pair.getSecond();
            }
            assert (columnIndex == 0) : columnIndex;
            FolderConfiguration configuration = (FolderConfiguration)pair.getFirst();
            if (configuration.isDefault()) {
                return "Default";
            }
            if (this.myItem.getType() == ResourceType.STRING && (locale = configuration.getLocaleQualifier()) != null && locale.hasLanguage() && (language = LocaleManager.getLanguageName((String)locale.getLanguage())) != null) {
                if (locale.hasRegion()) {
                    assert (locale.getRegion() != null);
                    String region = LocaleManager.getRegionName((String)locale.getRegion());
                    if (region != null) {
                        return language + ", " + region;
                    }
                }
                return language;
            }
            String qualifierString = configuration.getQualifierString();
            if (qualifierString.isEmpty()) {
                qualifierString = "Default";
            }
            return qualifierString;
        }
    }
}

