/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.core;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableOptional;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.google.common.base.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionalProperty<T>
extends AbstractProperty<Optional<T>>
implements ObservableOptional<T> {
    public final void setValue(@NotNull T value) {
        Optional opt = (Optional)this.get();
        if (!opt.isPresent() || !opt.get().equals(value)) {
            this.set(Optional.of(value));
        }
    }

    public final void clear() {
        if (((Optional)this.get()).isPresent()) {
            this.set(Optional.absent());
        }
    }

    public final void setNullableValue(@Nullable T value) {
        if (value != null) {
            this.setValue(value);
        } else {
            this.clear();
        }
    }

    @Override
    @NotNull
    public final ObservableBool isPresent() {
        return new BooleanExpression(new ObservableValue[]{this}){

            @Override
            @NotNull
            public Boolean get() {
                return ((Optional)OptionalProperty.this.get()).isPresent();
            }
        };
    }

    @Override
    @NotNull
    public final T getValue() {
        Optional opt = (Optional)this.get();
        return (T)opt.get();
    }

    @Override
    @NotNull
    public final T getValueOr(@NotNull T defaultValue) {
        Optional opt = (Optional)this.get();
        return (T)opt.or(defaultValue);
    }

    @Override
    @Nullable
    public final T getValueOrNull() {
        Optional opt = (Optional)this.get();
        return (T)opt.orNull();
    }
}

