/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.adapters;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.adapters.AdapterProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final DecimalFormat myFormat;

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty) {
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals) {
        this(wrappedProperty, numDecimals, numDecimals);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals, int maxDecimals) {
        super(wrappedProperty, 0.0);
        if (maxDecimals < numDecimals) {
            throw new IllegalArgumentException("maxDecimals must be larger or equal to numDecimals");
        }
        this.myFormat = new DecimalFormat("0." + StringUtil.repeat((String)"0", (int)numDecimals) + StringUtil.repeat((String)"#", (int)(maxDecimals - numDecimals)), new DecimalFormatSymbols());
    }

    @Override
    @Nullable
    protected Double convertFromSourceType(@NotNull String value) {
        try {
            ParsePosition pos = new ParsePosition(0);
            Number number = this.myFormat.parse(value, pos);
            if (number != null && pos.getIndex() == value.length()) {
                return number.doubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value) {
        return this.myFormat.format(value);
    }
}

