/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.adapters;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdapterProperty<S, D>
extends AbstractProperty<D>
implements InvalidationListener {
    @NotNull
    private final AbstractProperty<S> myWrappedProperty;
    private final BoolProperty myInSync = new BoolValueProperty();
    @NotNull
    private D myLastValue;
    private boolean myNeedsInitialSync = true;

    public AdapterProperty(@NotNull AbstractProperty<S> wrappedProperty, @NotNull D initialValue) {
        this.myLastValue = initialValue;
        this.myWrappedProperty = wrappedProperty;
        this.myWrappedProperty.addWeakListener(this);
    }

    @Override
    protected final void setDirectly(@NotNull D value) {
        this.myWrappedProperty.set(this.convertFromDestType(value));
    }

    @Override
    @NotNull
    public final D get() {
        this.doInitialSync();
        return this.myLastValue;
    }

    @NotNull
    public ObservableBool inSync() {
        this.doInitialSync();
        return this.myInSync;
    }

    @Override
    public final void onInvalidated(@NotNull ObservableValue<?> sender) {
        this.trySync();
        this.notifyInvalidated();
    }

    @Nullable
    protected abstract D convertFromSourceType(@NotNull S var1);

    @NotNull
    protected abstract S convertFromDestType(@NotNull D var1);

    private void doInitialSync() {
        if (this.myNeedsInitialSync) {
            this.trySync();
        }
    }

    private void trySync() {
        D result = this.convertFromSourceType(this.myWrappedProperty.get());
        this.myInSync.set(result != null);
        if (result != null) {
            this.myLastValue = result;
        }
        this.myNeedsInitialSync = false;
    }
}

