/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.expressions.bool.IsEqualToExpression;
import com.google.common.collect.Lists;
import com.intellij.util.containers.UnsafeWeakList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservableValue<T>
implements ObservableValue<T> {
    private final List<InvalidationListener> myListeners = Lists.newArrayListWithCapacity((int)0);
    private final UnsafeWeakList<InvalidationListener> myWeakListeners = new UnsafeWeakList(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener) {
        this.myListeners.remove(listener);
        this.myWeakListeners.remove((Object)listener);
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener) {
        this.myWeakListeners.add((Object)listener);
    }

    @Override
    @NotNull
    public final <S> Expression<S> transform(final @NotNull Function<T, S> function) {
        return new Expression<S>(new ObservableValue[]{this}){

            @Override
            @NotNull
            public S get() {
                return function.apply(AbstractObservableValue.this.get());
            }
        };
    }

    @Override
    @NotNull
    public final ObservableBool isEqualTo(@NotNull T value) {
        return new IsEqualToExpression<T>(this, value);
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener : this.myListeners) {
            listener.onInvalidated(this);
        }
        for (InvalidationListener listener : this.myWeakListeners) {
            listener.onInvalidated(this);
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

