/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderingContext {
    private final Project myProject;
    private final String myTitle;
    private final Map<String, Object> myParamMap;
    private final File myOutputRoot;
    private final File myModuleRoot;
    private final boolean myGradleSync;
    private final boolean myFindOnlyReferences;
    private final StudioTemplateLoader myLoader;
    private final Configuration myFreemarker;
    private final Collection<File> mySourceFiles;
    private final Collection<File> myTargetFiles;
    private final Collection<File> myFilesToOpen;
    private final Collection<String> myPlugins;
    private final Collection<String> myClasspathEntries;
    private final SetMultimap<String, String> myDependencies;
    private final Collection<String> myWarnings;
    private final boolean myDryRun;
    private final boolean myShowErrors;

    private RenderingContext(@Nullable Project project, @NotNull File initialTemplatePath, @NotNull String commandName, @NotNull Map<String, Object> paramMap, @NotNull File outputRoot, @NotNull File moduleRoot, boolean gradleSyncIfNeeded, boolean findOnlyReferences, boolean dryRun, boolean showErrors, @Nullable Collection<File> outSourceFiles, @Nullable Collection<File> outTargetFiles, @Nullable Collection<File> outOpenFiles, @Nullable Collection<String> outPlugins, @Nullable Collection<String> outClasspathEntries, @Nullable SetMultimap<String, String> outDependencies) {
        this.myProject = RenderingContext.useDefaultProjectIfNeeded(project);
        this.myTitle = commandName;
        this.myParamMap = Template.createParameterMap(paramMap);
        this.myOutputRoot = outputRoot;
        this.myModuleRoot = moduleRoot;
        this.myGradleSync = gradleSyncIfNeeded;
        this.myFindOnlyReferences = findOnlyReferences;
        this.myDryRun = dryRun;
        this.myShowErrors = showErrors;
        this.myLoader = new StudioTemplateLoader(initialTemplatePath);
        this.myFreemarker = new FreemarkerConfiguration();
        this.myFreemarker.setTemplateLoader((TemplateLoader)this.myLoader);
        this.mySourceFiles = outSourceFiles != null ? outSourceFiles : Lists.newArrayList();
        this.myTargetFiles = outTargetFiles != null ? outTargetFiles : Lists.newArrayList();
        this.myFilesToOpen = outOpenFiles != null ? outOpenFiles : Lists.newArrayList();
        this.myPlugins = outPlugins != null ? outPlugins : Lists.newArrayList();
        this.myClasspathEntries = outClasspathEntries != null ? outClasspathEntries : Lists.newArrayList();
        this.myDependencies = outDependencies != null ? outDependencies : LinkedHashMultimap.create();
        this.myWarnings = Lists.newArrayList();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getCommandName() {
        return this.myTitle;
    }

    @NotNull
    public Map<String, Object> getParamMap() {
        return this.myParamMap;
    }

    @NotNull
    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    @NotNull
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    public boolean performGradleSync() {
        return this.myGradleSync;
    }

    public boolean showErrors() {
        return this.myShowErrors;
    }

    public boolean showWarnings() {
        return this.myShowErrors && this.myDryRun;
    }

    @NotNull
    public StudioTemplateLoader getLoader() {
        return this.myLoader;
    }

    @NotNull
    public Configuration getFreemarkerConfiguration() {
        return this.myFreemarker;
    }

    @NotNull
    public Collection<File> getTargetFiles() {
        return this.myTargetFiles;
    }

    @NotNull
    public Collection<File> getFilesToOpen() {
        return this.myFilesToOpen;
    }

    @NotNull
    public Collection<String> getPlugins() {
        return this.myPlugins;
    }

    @NotNull
    public Collection<String> getClasspathEntries() {
        return this.myClasspathEntries;
    }

    @NotNull
    public SetMultimap<String, String> getDependencies() {
        return this.myDependencies;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        return this.mySourceFiles;
    }

    @NotNull
    public Collection<String> getWarnings() {
        return this.myWarnings;
    }

    public RecipeExecutor getRecipeExecutor() {
        if (this.myFindOnlyReferences) {
            return new FindReferencesRecipeExecutor(this);
        }
        return new DefaultRecipeExecutor(this, this.myDryRun);
    }

    public boolean shouldReformat() {
        return !this.myDryRun && this.myProject.isInitialized();
    }

    public boolean canCausePartialRendering() {
        return !this.myDryRun;
    }

    @NotNull
    private static Project useDefaultProjectIfNeeded(@Nullable Project project) {
        return project != null ? project : ProjectManagerEx.getInstanceEx().getDefaultProject();
    }

    public static final class Builder {
        private final File myInitialTemplatePath;
        private final Project myProject;
        private String myCommandName;
        private Map<String, Object> myParams;
        private File myOutputRoot;
        private File myModuleRoot;
        private boolean myGradleSync;
        private boolean myFindOnlyReferences;
        private boolean myDryRun;
        private boolean myShowErrors;
        private Collection<File> mySourceFiles;
        private Collection<File> myTargetFiles;
        private Collection<File> myOpenFiles;
        private Collection<String> myPlugins;
        private Collection<String> myClasspathEntries;
        private SetMultimap<String, String> myDependencies;

        private Builder(@NotNull File initialTemplatePath, @NotNull Project project) {
            this.myInitialTemplatePath = initialTemplatePath;
            this.myProject = project;
            this.myCommandName = "Instantiate Template";
            this.myParams = Collections.emptyMap();
            this.myModuleRoot = this.myOutputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
            this.myGradleSync = true;
            this.myFindOnlyReferences = false;
            this.myDryRun = false;
            this.myShowErrors = false;
        }

        public static Builder newContext(@NotNull Template template, @NotNull Project project) {
            return new Builder(template.getRootPath(), project);
        }

        public static Builder newContext(@NotNull File templateRootPath, @NotNull Project project) {
            return new Builder(templateRootPath, project);
        }

        public Builder withCommandName(@NotNull String commandName) {
            this.myCommandName = commandName;
            return this;
        }

        public Builder withModule(@NotNull Module module) {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            assert (roots.length > 0);
            this.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            return this;
        }

        public Builder withOutputRoot(@NotNull File outputRoot) {
            this.myOutputRoot = outputRoot;
            return this;
        }

        public Builder withModuleRoot(@NotNull File moduleRoot) {
            this.myModuleRoot = moduleRoot;
            return this;
        }

        public Builder withParams(@NotNull Map<String, Object> params) {
            this.myParams = params;
            return this;
        }

        public Builder withGradleSync(boolean gradleSync) {
            this.myGradleSync = gradleSync;
            return this;
        }

        public Builder withFindOnlyReferences(boolean findOnlyReferences) {
            this.myFindOnlyReferences = findOnlyReferences;
            return this;
        }

        public Builder withDryRun(boolean dryRun) {
            this.myDryRun = dryRun;
            return this;
        }

        public Builder withShowErrors(boolean showErrors) {
            this.myShowErrors = showErrors;
            return this;
        }

        public Builder intoSourceFiles(@Nullable Collection<File> sourceFiles) {
            this.mySourceFiles = sourceFiles;
            return this;
        }

        public Builder intoTargetFiles(@Nullable Collection<File> targetFiles) {
            this.myTargetFiles = targetFiles;
            return this;
        }

        public Builder intoOpenFiles(@Nullable Collection<File> openFiles) {
            this.myOpenFiles = openFiles;
            return this;
        }

        public Builder intoPlugins(@Nullable Collection<String> plugins) {
            this.myPlugins = plugins;
            return this;
        }

        public Builder intoClasspathEntries(@Nullable Collection<String> classpathEntries) {
            this.myClasspathEntries = classpathEntries;
            return this;
        }

        public Builder intoDependencies(@Nullable SetMultimap<String, String> dependencies) {
            this.myDependencies = dependencies;
            return this;
        }

        public RenderingContext build() {
            if (this.myDryRun) {
                this.mySourceFiles = null;
                this.myTargetFiles = null;
                this.myOpenFiles = null;
                this.myClasspathEntries = null;
                this.myDependencies = null;
            }
            return new RenderingContext(this.myProject, this.myInitialTemplatePath, this.myCommandName, this.myParams, this.myOutputRoot, this.myModuleRoot, this.myGradleSync, this.myFindOnlyReferences, this.myDryRun, this.myShowErrors, this.mySourceFiles, this.myTargetFiles, this.myOpenFiles, this.myPlugins, this.myClasspathEntries, this.myDependencies);
        }
    }
}

