/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import com.intellij.openapi.util.io.FileUtil;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioTemplateLoader
implements TemplateLoader {
    private final File myTemplateRootFolder;
    private final Stack<File> myLastTemplateFolders;
    private static final String ROOT = "root://";

    public StudioTemplateLoader(@NotNull File templateFolder) {
        this.myTemplateRootFolder = StudioTemplateLoader.findTemplateRootFolder(templateFolder);
        this.myLastTemplateFolders = new Stack();
        this.myLastTemplateFolders.push(templateFolder);
    }

    public void pushTemplateFolder(@NotNull File folder) {
        this.myLastTemplateFolders.push(folder);
    }

    public void pushTemplateFolder(@NotNull String folderName) throws IOException {
        this.myLastTemplateFolders.push(this.resolveName(folderName));
    }

    public void popTemplateFolder() {
        this.myLastTemplateFolders.pop();
    }

    @NotNull
    public String findTemplate(@NotNull File file) throws IOException {
        String path;
        if (!file.isAbsolute()) {
            file = this.resolveName(file.getPath());
        }
        if ((path = FileUtil.getRelativePath((File)this.myTemplateRootFolder, (File)file)) == null) {
            throw new IOException("Absolute paths must start with: " + this.myTemplateRootFolder.getPath());
        }
        return ROOT + FileUtil.toSystemIndependentName((String)path);
    }

    @NotNull
    public File getSourceFile(@NotNull File file) throws IOException {
        String name = this.findTemplate(file);
        return this.resolveName(name);
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        File file = this.resolveName(name);
        TemplateSource templateSource = TemplateSource.open(file);
        this.pushTemplateFolder(file.getParentFile());
        return templateSource;
    }

    public long getLastModified(Object source) {
        TemplateSource templateSource = (TemplateSource)source;
        return templateSource.getLastModified();
    }

    @NotNull
    public Reader getReader(@NotNull Object source, @NotNull String encoding) throws IOException {
        TemplateSource templateSource = (TemplateSource)source;
        return new InputStreamReader(templateSource.getInputStream(), encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        TemplateSource templateSource = (TemplateSource)source;
        this.popTemplateFolder();
        templateSource.close();
    }

    @NotNull
    private File resolveName(@NotNull String name) throws IOException {
        File file = name.startsWith(ROOT) ? new File(this.myTemplateRootFolder, name.substring(ROOT.length())) : (this.myLastTemplateFolders != null ? new File(this.myLastTemplateFolders.peek(), name) : new File(this.myTemplateRootFolder, name));
        return file.getCanonicalFile();
    }

    @NotNull
    private static File findTemplateRootFolder(@NotNull File templateFolder) {
        File folder;
        for (folder = templateFolder; folder != null && !folder.getName().equals("templates"); folder = folder.getParentFile()) {
        }
        return folder != null ? folder : templateFolder;
    }

    private static final class TemplateSource {
        private final InputStream myInputStream;
        private final long myLastModifiedTime;

        private TemplateSource(@NotNull InputStream inputStream, long lastModified) {
            this.myInputStream = inputStream;
            this.myLastModifiedTime = lastModified;
        }

        public static TemplateSource open(@NotNull File file) throws IOException {
            if (!file.exists() && !file.isFile()) {
                return null;
            }
            return new TemplateSource(SdkUtils.fileToUrl((File)file).openStream(), file.lastModified());
        }

        @NotNull
        public InputStream getInputStream() {
            return this.myInputStream;
        }

        public long getLastModified() {
            return this.myLastModifiedTime;
        }

        public void close() throws IOException {
            this.myInputStream.close();
        }
    }
}

