/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services.view;

import com.android.tools.idea.structure.EditorPanel;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServices;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.view.DeveloperServicePanel;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public final class DeveloperServicesPanel
extends EditorPanel {
    private final List<DeveloperServicePanel> myPanelsList;
    private JPanel myRoot;
    private JComboBox myModuleCombo;
    private JPanel myServicesPanel;
    private JPanel myHeaderPanel;
    private JBScrollPane myScrollPane;

    public DeveloperServicesPanel(@NotNull ComboBoxModel moduleList, final @NotNull ServiceCategory serviceCategory) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myPanelsList = Lists.newArrayList();
        ListCellRendererWrapper<Module> renderer = new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
            }
        };
        this.myModuleCombo.setModel(moduleList);
        this.myModuleCombo.setRenderer(renderer);
        JScrollBar scrollBar = this.myScrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(5);
        scrollBar.setBlockIncrement(10);
        this.myServicesPanel.setBorder(new TitledBorder(serviceCategory.getDisplayName()));
        this.updateServicePanels(serviceCategory);
        this.myModuleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeveloperServicesPanel.this.updateServicePanels(serviceCategory);
            }
        });
        this.add(this.myRoot);
    }

    @Override
    public void apply() {
        for (DeveloperServicePanel panel : this.myPanelsList) {
            panel.apply();
        }
    }

    @Override
    public boolean isModified() {
        for (DeveloperServicePanel panel : this.myPanelsList) {
            if (!panel.isModified()) continue;
            return true;
        }
        return false;
    }

    private void createUIComponents() {
        this.myServicesPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
    }

    private void updateServicePanels(@NotNull ServiceCategory serviceCategory) {
        for (DeveloperServicePanel developerServicePanel : this.myPanelsList) {
            developerServicePanel.dispose();
        }
        this.myPanelsList.clear();
        this.myServicesPanel.removeAll();
        Module module = (Module)this.myModuleCombo.getSelectedItem();
        if (module == null) {
            return;
        }
        for (DeveloperService service : DeveloperServices.getFor(module, serviceCategory)) {
            if (service.getContext().hiddenFromStructureDialog().get().booleanValue()) continue;
            this.myPanelsList.add(new DeveloperServicePanel(service));
        }
        for (DeveloperServicePanel panel : this.myPanelsList) {
            if (this.myServicesPanel.getComponentCount() > 0) {
                this.myServicesPanel.add((Component)new SeparatorComponent());
            }
            this.myServicesPanel.add(panel);
        }
        this.myServicesPanel.validate();
        this.myServicesPanel.repaint();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.setOpaque(false);
        this.myHeaderPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Target:");
        Component component = jPanel.add(jLabel);
        this.myModuleCombo = jComboBox = new JComboBox();
        Component component2 = jPanel.add(jComboBox);
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = this.myServicesPanel;
        jPanel3.setOpaque(false);
        jBScrollPane.setViewportView(jPanel3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

