/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.structure.dialog.AndroidConfigurableContributor;
import com.android.tools.idea.structure.dialog.ConfigurationErrorsComponent;
import com.android.tools.idea.structure.dialog.CounterDisplayConfigurable;
import com.android.tools.idea.structure.dialog.ProjectStructureItemGroup;
import com.android.tools.idea.structure.dialog.SidePanel;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Place.Navigator,
Configurable.NoMargin,
Configurable.NoScroll {
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    @NonNls
    private static final String CATEGORY = "category";
    @NonNls
    private static final String CATEGORY_NAME = "categoryName";
    @NonNls
    private static final String LAST_EDITED_PROPERTY = "project.structure.last.edited";
    @NonNls
    private static final String PROPORTION_PROPERTY = "project.structure.proportion";
    @NonNls
    private static final String SIDE_PROPORTION_PROPERTY = "project.structure.side.proportion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeSdksConfigurable mySdksConfigurable;
    @NotNull
    private final Wrapper myDetails = new Wrapper();
    @NotNull
    private final List<Configurable> myConfigurables = Lists.newArrayList();
    @NotNull
    private final UIState myUiState = new UIState();
    private History myHistory = new History((Place.Navigator)this);
    private JBSplitter mySplitter;
    private SidePanel mySidePanel;
    private JPanel myNotificationPanel;
    private JComponent myToolbarComponent;
    private ConfigurationErrorsComponent myErrorsComponent;
    private JComponent myToFocus;
    private boolean myUiInitialized;
    private Configurable mySelectedConfigurable;
    private final JLabel myEmptySelection = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);
    private final EventDispatcher<ProjectStructureChangeListener> myChangeEventDispatcher = EventDispatcher.create(ProjectStructureChangeListener.class);
    private MyDisposable myDisposable = new MyDisposable();

    @NotNull
    public static ProjectStructureConfigurable getInstance(@NotNull Project project) {
        return (ProjectStructureConfigurable)((Object)ServiceManager.getService((Project)project, ProjectStructureConfigurable.class));
    }

    public ProjectStructureConfigurable(@NotNull Project project) {
        this.myProject = project;
        this.mySdksConfigurable = new IdeSdksConfigurable(this, project);
        this.mySdksConfigurable.setHistory(this.myHistory);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue(LAST_EDITED_PROPERTY);
        String proportion = propertiesComponent.getValue(PROPORTION_PROPERTY);
        this.myUiState.proportion = ProjectStructureConfigurable.parseFloatValue(proportion);
        String sideProportion = propertiesComponent.getValue(SIDE_PROPORTION_PROPERTY);
        this.myUiState.sideProportion = ProjectStructureConfigurable.parseFloatValue(sideProportion);
    }

    private static float parseFloatValue(@Nullable String value) {
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    private boolean showDialog(@Nullable Runnable advanceInit) {
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        BaseConfigurable configurable;
        if (place == null) {
            return ActionCallback.DONE;
        }
        Object displayName = place.getPath(CATEGORY_NAME);
        Configurable toSelect = displayName instanceof String ? this.findConfigurable((String)displayName) : (Configurable)place.getPath(CATEGORY);
        JComponent detailsContent = this.myDetails.getTargetComponent();
        if (this.mySelectedConfigurable != toSelect) {
            this.saveSideProportion();
            this.removeSelected();
        }
        if (toSelect != null) {
            detailsContent = toSelect.createComponent();
            this.myDetails.setContent(detailsContent);
        }
        this.mySelectedConfigurable = toSelect;
        if (this.mySelectedConfigurable != null) {
            this.myUiState.lastEditedConfigurable = this.mySelectedConfigurable.getDisplayName();
        }
        if (toSelect instanceof MasterDetailsComponent) {
            MasterDetailsComponent masterDetails = (MasterDetailsComponent)toSelect;
            if (this.myUiState.sideProportion > 0.0f) {
                masterDetails.getSplitter().setProportion(this.myUiState.sideProportion);
            }
            masterDetails.setHistory(this.myHistory);
        } else if (toSelect == this.mySdksConfigurable) {
            this.mySdksConfigurable.setHistory(this.myHistory);
        }
        if (toSelect != null) {
            this.mySidePanel.select(ProjectStructureConfigurable.createPlaceFor(toSelect));
        }
        JComponent toFocus = null;
        if (this.mySelectedConfigurable instanceof BaseConfigurable) {
            configurable = (BaseConfigurable)this.mySelectedConfigurable;
            toFocus = configurable.getPreferredFocusedComponent();
        } else if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            configurable = (MasterDetailsComponent)this.mySelectedConfigurable;
            toFocus = configurable.getMaster();
        }
        if (toFocus == null && detailsContent != null && (toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)detailsContent)) == null) {
            toFocus = detailsContent;
        }
        this.myToFocus = toFocus;
        if (this.myToFocus != null) {
            UIUtil.requestFocus((JComponent)this.myToFocus);
        }
        ActionCallback result = new ActionCallback();
        Place.goFurther((Object)toSelect, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        this.myDetails.revalidate();
        this.myDetails.repaint();
        if (!this.myHistory.isNavigatingNow() && this.mySelectedConfigurable != null) {
            this.myHistory.pushQueryPlace();
        }
        return result;
    }

    @Nullable
    private Configurable findConfigurable(@NotNull String displayName) {
        for (Configurable configurable : this.myConfigurables) {
            if (!displayName.equals(configurable.getDisplayName())) continue;
            return configurable;
        }
        return null;
    }

    private void saveSideProportion() {
        if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.mySelectedConfigurable).getSplitter().getProportion();
        }
    }

    private void removeSelected() {
        this.myDetails.removeAll();
        this.mySelectedConfigurable = null;
        this.myUiState.lastEditedConfigurable = null;
        this.myDetails.add((Component)this.myEmptySelection, (Object)"Center");
    }

    public void queryPlace(@NotNull Place place) {
        if (this.mySelectedConfigurable != null) {
            place.putPath(CATEGORY, (Object)this.mySelectedConfigurable);
            Place.queryFurther((Object)this.mySelectedConfigurable, (Place)place);
        }
    }

    @NotNull
    public String getId() {
        return "android.project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.mySelectedConfigurable != null ? this.mySelectedConfigurable.getHelpTopic() : "";
    }

    @Nullable
    public JComponent createComponent() {
        MyPanel component = new MyPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new BackAction((JComponent)component));
        toolbarGroup.add((AnAction)new ForwardAction((JComponent)component));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)component);
        this.myToolbarComponent = toolbar.getComponent();
        left.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myToolbarComponent.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        left.add((Component)this.myToolbarComponent, "North");
        left.add((Component)this.mySidePanel, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component.add((Component)this.mySplitter, "Center");
        this.myErrorsComponent = new ConfigurationErrorsComponent(this.myProject);
        component.add((Component)this.myErrorsComponent, "South");
        this.myUiInitialized = true;
        return component;
    }

    private void initSidePanel() {
        boolean isDefaultProject = this.myProject == ProjectManager.getInstance().getDefaultProject();
        this.mySidePanel = new SidePanel(this, this.myHistory);
        this.addConfigurable((Configurable)this.mySdksConfigurable);
        if (!isDefaultProject) {
            this.addConfigurables();
        }
    }

    private void addConfigurables() {
        if (this.myDisposable.disposed) {
            this.myDisposable = new MyDisposable();
        }
        ArrayList additionalConfigurableGroups = Lists.newArrayList();
        for (AndroidConfigurableContributor contributor : (AndroidConfigurableContributor[])AndroidConfigurableContributor.EP_NAME.getExtensions()) {
            contributor.getMainConfigurables(this.myProject, this.myDisposable).forEach(this::addConfigurable);
            additionalConfigurableGroups.addAll(contributor.getAdditionalConfigurableGroups());
        }
        for (ProjectStructureItemGroup group : additionalConfigurableGroups) {
            String name = group.getGroupName();
            this.mySidePanel.addSeparator(name);
            group.getItems().forEach(this::addConfigurable);
        }
    }

    private void addConfigurable(@NotNull Configurable configurable) {
        this.myConfigurables.add(configurable);
        if (configurable instanceof Place.Navigator) {
            Place.Navigator navigator = (Place.Navigator)configurable;
            navigator.setHistory(this.myHistory);
        }
        this.mySidePanel.addPlace(ProjectStructureConfigurable.createPlaceFor(configurable), new Presentation(configurable.getDisplayName()));
        if (configurable instanceof CounterDisplayConfigurable) {
            ((CounterDisplayConfigurable)configurable).add(() -> UIUtil.invokeLaterIfNeeded(() -> this.mySidePanel.repaint()), this.myDisposable);
        }
    }

    public static void putPath(@NotNull Place place, @NotNull Configurable configurable) {
        place.putPath(CATEGORY_NAME, (Object)configurable.getDisplayName());
    }

    @Nullable
    public <T extends Configurable> T findConfigurable(@NotNull Class<T> type) {
        for (Configurable configurable : this.myConfigurables) {
            if (!type.isInstance(configurable)) continue;
            return (T)((Configurable)type.cast(configurable));
        }
        return null;
    }

    @NotNull
    private static Place createPlaceFor(@NotNull Configurable configurable) {
        return new Place().putPath(CATEGORY, (Object)configurable);
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        boolean applied = false;
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            configurable.apply();
            applied = true;
        }
        if (applied) {
            ((ProjectStructureChangeListener)this.myChangeEventDispatcher.getMulticaster()).projectStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting Project Structure");
        try {
            this.mySdksConfigurable.reset();
            Configurable toSelect = null;
            for (Configurable each : this.myConfigurables) {
                if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(each.getDisplayName())) {
                    toSelect = each;
                }
                if (each instanceof MasterDetailsComponent) {
                    ((MasterDetailsComponent)each).setHistory(this.myHistory);
                }
                each.reset();
            }
            this.myHistory.clear();
            if (toSelect == null && !this.myConfigurables.isEmpty()) {
                toSelect = this.myConfigurables.get(0);
            }
            this.removeSelected();
            this.navigateTo(toSelect != null ? ProjectStructureConfigurable.createPlaceFor(toSelect) : null, false);
            if (this.myUiState.proportion > 0.0f) {
                this.mySplitter.setProportion(this.myUiState.proportion);
            }
        }
        finally {
            token.finish();
        }
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(LAST_EDITED_PROPERTY, this.myUiState.lastEditedConfigurable);
        propertiesComponent.setValue(PROPORTION_PROPERTY, String.valueOf(this.myUiState.proportion));
        propertiesComponent.setValue(SIDE_PROPORTION_PROPERTY, String.valueOf(this.myUiState.sideProportion));
        this.myUiState.proportion = this.mySplitter.getProportion();
        this.saveSideProportion();
        this.myConfigurables.forEach(UnnamedConfigurable::disposeUIResources);
        this.myConfigurables.clear();
        Disposer.dispose((Disposable)this.myErrorsComponent);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myUiInitialized = false;
    }

    @Nullable
    public History getHistory() {
        return this.myHistory;
    }

    public void add(@NotNull ProjectStructureChangeListener listener, @NotNull Disposable parentDisposable) {
        this.myChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void add(@NotNull ProjectStructureChangeListener listener) {
        this.myChangeEventDispatcher.addListener((EventListener)listener);
    }

    public void remove(@NotNull ProjectStructureChangeListener listener) {
        this.myChangeEventDispatcher.removeListener((EventListener)listener);
    }

    public static interface ProjectStructureChangeListener
    extends EventListener {
        public void projectStructureChanged();
    }

    private static class MyDisposable
    implements Disposable {
        volatile boolean disposed;

        private MyDisposable() {
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        @Nullable
        public String lastEditedConfigurable;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(dataId)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }
    }
}

