/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.IntelliJLogger;
import com.android.utils.ILogger;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import com.intellij.openapi.application.ApplicationInfo;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioUsageTracker {
    private static final String ANONYMIZATION_ERROR = "*ANONYMIZATION_ERROR*";
    public static ILogger LOGGER = new IntelliJLogger(AndroidStudioUsageTracker.class);

    public static void setup(ScheduledExecutorService scheduler) {
        scheduler.scheduleWithFixedDelay(AndroidStudioUsageTracker::runDailyReports, 0L, 1L, TimeUnit.DAYS);
    }

    private static void runDailyReports() {
        UsageTracker tracker = UsageTracker.getInstance();
        ApplicationInfo application = ApplicationInfo.getInstance();
        tracker.log(AndroidStudioStats.AndroidStudioEvent.newBuilder().setCategory(AndroidStudioStats.AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioStats.AndroidStudioEvent.EventKind.STUDIO_PING).setProductDetails(AndroidStudioStats.ProductDetails.newBuilder().setProduct(AndroidStudioStats.ProductDetails.ProductKind.STUDIO).setBuild(application.getBuild().asStringWithAllDetails()).setVersion(application.getStrictVersion()).setOsArchitecture(CommonMetricsData.getOsArchitecture())));
    }

    @NotNull
    public static String anonymizeUtf8(@NotNull String value) {
        try {
            return Anonymizer.anonymizeUtf8((ILogger)LOGGER, (String)value);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Unable to read anonymization settings, not reporting any values", new Object[0]);
            return ANONYMIZATION_ERROR;
        }
    }

    @NotNull
    public static AndroidStudioStats.DeviceInfo deviceToDeviceInfo(@NotNull IDevice device) {
        return AndroidStudioStats.DeviceInfo.newBuilder().setAnonymizedSerialNumber(AndroidStudioUsageTracker.anonymizeUtf8(device.getSerialNumber())).setBuildTags(Strings.nullToEmpty((String)device.getProperty("ro.build.tags"))).setBuildType(Strings.nullToEmpty((String)device.getProperty("ro.build.type"))).setBuildVersionRelease(Strings.nullToEmpty((String)device.getProperty("ro.build.version.release"))).setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device.getProperty("ro.product.cpu.abi"))).setManufacturer(Strings.nullToEmpty((String)device.getProperty("ro.product.manufacturer"))).setModel(Strings.nullToEmpty((String)device.getProperty("ro.product.model"))).build();
    }

    @NotNull
    public static AndroidStudioStats.DeviceInfo deviceToDeviceInfoApilLevelOnly(@NotNull IDevice device) {
        return AndroidStudioStats.DeviceInfo.newBuilder().setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).build();
    }
}

