/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.License;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.ui.properties.core.ObservableOptional;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class LicenseAgreementModel
extends WizardModel {
    private final Set<License> myLicenses = Sets.newHashSet();
    private final OptionalProperty<File> mySdkRoot = new OptionalValueProperty<File>();

    public Set<License> getLicenses() {
        return this.myLicenses;
    }

    public ObservableOptional<File> sdkRoot() {
        return this.mySdkRoot;
    }

    private static Logger getLog() {
        return Logger.getInstance(LicenseAgreementModel.class);
    }

    public LicenseAgreementModel(@Nullable File sdkLocation) {
        if (sdkLocation != null) {
            this.mySdkRoot.setValue(sdkLocation);
        } else {
            this.mySdkRoot.clear();
        }
    }

    @Override
    protected void handleFinished() {
        if (!((Optional)this.mySdkRoot.get()).isPresent()) {
            LicenseAgreementModel.getLog().error("The wizard could not find the SDK repository folder and will not complete. Please report this error.");
            return;
        }
        for (License license : this.myLicenses) {
            license.setAccepted(this.mySdkRoot.getValue(), FileOpUtils.create());
        }
    }
}

