/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallerUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.FalseValidator;
import com.android.tools.idea.ui.validation.validators.TrueValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSelectedPackagesStep
extends ModelWizardStep.WithoutModel {
    private final BoolProperty myInstallFailed;
    private final BoolProperty myInstallationFinished;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myContentPanel;
    private JBLabel myLabelSdkPath;
    private JBLabel myProgressOverallLabel;
    private JTextArea mySdkManagerOutput;
    private JProgressBar myProgressBar;
    private JBLabel myProgressDetailLabel;
    private List<UpdatablePackage> myInstallRequests;
    private Collection<LocalPackage> myUninstallRequests;
    private final RepoManager myRepoManager;
    private final AndroidSdkHandler mySdkHandler;
    private com.android.repository.api.ProgressIndicator myLogger;
    private static final Object LOGGER_LOCK = new Object();
    private final BackgroundAction myBackgroundAction;
    private final boolean myBackgroundable;

    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull AndroidSdkHandler sdkHandler, boolean backgroundable) {
        super("Component Installer");
        this.$$$setupUI$$$();
        this.myInstallFailed = new BoolValueProperty();
        this.myInstallationFinished = new BoolValueProperty();
        this.myBackgroundAction = new BackgroundAction();
        this.myInstallRequests = installRequests;
        this.myUninstallRequests = uninstallRequests;
        this.mySdkHandler = sdkHandler;
        this.myRepoManager = sdkHandler.getSdkManager((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        this.myValidatorPanel = new ValidatorPanel(this, this.myContentPanel);
        this.myStudioPanel = new StudioWizardStepPanel(this.myValidatorPanel, "Installing Requested Components");
        this.myBackgroundable = backgroundable;
    }

    @Override
    public Action getExtraAction() {
        return this.myBackgroundable ? this.myBackgroundAction : null;
    }

    private static void checkForUpgrades(@Nullable List<UpdatablePackage> completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (UpdatablePackage updated : completedChanges) {
            int api;
            TypeDetails details = updated.getRepresentative().getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (api = ((DetailsTypes.PlatformDetailsType)details).getApiLevel()) <= highestNewApiLevel) continue;
            highestNewApiLevel = api;
        }
        if (highestNewApiLevel > 0) {
            PropertiesComponent.getInstance().setValue(WizardConstants.NEWLY_INSTALLED_API_KEY.name, highestNewApiLevel, -1);
        }
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        String finishedText = "Please wait until the installation finishes to continue";
        this.myValidatorPanel.registerValidator(this.myInstallationFinished, new TrueValidator(Validator.Severity.INFO, finishedText));
        String installError = "Install failed. Please check the installation log and try again.";
        this.myValidatorPanel.registerValidator(this.myInstallFailed, new FalseValidator(installError));
        this.myBackgroundAction.setWizard(wizard);
    }

    @Override
    protected void onEntering() {
        this.mySdkManagerOutput.setText("");
        this.myLabelSdkPath.setText(this.myRepoManager.getLocalPath().getPath());
        this.startSdkInstall();
    }

    @Override
    protected boolean shouldShow() {
        return !this.myInstallRequests.isEmpty() || !this.myUninstallRequests.isEmpty();
    }

    @Override
    public boolean canGoBack() {
        return false;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myInstallationFinished;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = LOGGER_LOCK;
        synchronized (object) {
            if (this.myLogger != null && !this.myBackgroundAction.isBackgrounded()) {
                this.myLogger.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdkInstall() {
        CustomLogger customLogger = new CustomLogger();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            this.myLogger = new ThrottledProgressWrapper(customLogger);
        }
        InstallTask task = new InstallTask(this.myInstallRequests, this.myUninstallRequests, this.myLogger);
        boolean hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
        Object indicator = hasOpenProjects ? new BackgroundableProcessIndicator((Task.Backgroundable)task) : new EmptyProgressIndicator();
        customLogger.setIndicator((ProgressIndicator)indicator);
        this.myLogger.logInfo("To install:");
        for (UpdatablePackage p : this.myInstallRequests) {
            this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getRemote().getDisplayName(), p.getRemote().getPath()));
        }
        this.myLogger.logInfo("");
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JTextArea jTextArea;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myProgressOverallLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myProgressDetailLabel = jBLabel = new JBLabel();
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setVerticalAlignment(1);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class BackgroundAction
    extends AbstractAction {
        private boolean myIsBackgrounded = false;
        private ModelWizard.Facade myWizard;

        public BackgroundAction() {
            super("Background");
        }

        public void setWizard(@NotNull ModelWizard.Facade wizard) {
            this.myWizard = wizard;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myIsBackgrounded = true;
            this.myWizard.cancel();
        }

        public boolean isBackgrounded() {
            return this.myIsBackgrounded;
        }
    }

    private final class CustomLogger
    implements com.android.repository.api.ProgressIndicator {
        private ProgressIndicator myIndicator;
        private boolean myCancelled;
        private Logger myLogger = Logger.getInstance(this.getClass());

        private CustomLogger() {
        }

        public void setText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressOverallLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText(s);
            }
        }

        public boolean isCanceled() {
            return this.myCancelled;
        }

        public void cancel() {
            this.myCancelled = true;
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }

        public void setCancellable(boolean cancellable) {
        }

        public boolean isCancellable() {
            return true;
        }

        public void setIndeterminate(boolean indeterminate) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(indeterminate));
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(indeterminate);
            }
        }

        public boolean isIndeterminate() {
            return InstallSelectedPackagesStep.this.myProgressBar.isIndeterminate();
        }

        public void setFraction(double v) {
            UIUtil.invokeLaterIfNeeded(() -> {
                InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(false);
                InstallSelectedPackagesStep.this.myProgressBar.setValue((int)(v * (double)(InstallSelectedPackagesStep.this.myProgressBar.getMaximum() - InstallSelectedPackagesStep.this.myProgressBar.getMinimum())));
            });
            if (this.myIndicator != null) {
                this.myIndicator.setFraction(v);
            }
        }

        public double getFraction() {
            return InstallSelectedPackagesStep.this.myProgressBar.getPercentComplete();
        }

        public void setSecondaryText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressDetailLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText2(s);
            }
        }

        public void logWarning(@NotNull String s) {
            this.appendText(s);
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s);
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            this.appendText(s);
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s);
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            this.appendText(s);
            this.myLogger.info(s);
        }

        private void appendText(@NotNull String s) {
            UIUtil.invokeLaterIfNeeded(() -> {
                String current = InstallSelectedPackagesStep.this.mySdkManagerOutput.getText();
                if (current == null) {
                    current = "";
                }
                InstallSelectedPackagesStep.this.mySdkManagerOutput.setText(current + "\n" + s);
            });
        }

        public void setIndicator(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }
    }

    private class InstallTask
    extends Task.Backgroundable {
        @NotNull
        private final List<UpdatablePackage> myRequestedPackages;
        @NotNull
        private final Collection<LocalPackage> myUninstallPackages;
        @NotNull
        private final com.android.repository.api.ProgressIndicator myProgress;

        public void onCancel() {
            this.myProgress.cancel();
        }

        private InstallTask(@NotNull List<UpdatablePackage> requestedPackages, @NotNull Collection<LocalPackage> uninstallPackages, com.android.repository.api.ProgressIndicator progress) {
            super(null, "Installing Android SDK", true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myRequestedPackages = requestedPackages;
            this.myUninstallPackages = uninstallPackages;
            this.myProgress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            Iterator iterator;
            ArrayList failures;
            block20: {
                block21: {
                    failures = Lists.newArrayList();
                    LinkedHashMap preparedPackages = Maps.newLinkedHashMap();
                    try {
                        PackageOperation installer;
                        for (UpdatablePackage updatable : this.myRequestedPackages) {
                            installer = this.getOrCreateInstaller((RepoPackage)updatable.getRemote(), indicator);
                            this.processPackage((RepoPackage)updatable.getRemote(), installer, preparedPackages, failures);
                        }
                        for (LocalPackage uninstall : this.myUninstallPackages) {
                            this.processPackage((RepoPackage)uninstall, this.getOrCreateUninstaller((RepoPackage)uninstall), preparedPackages, failures);
                        }
                        InstallSelectedPackagesStep.this.myBackgroundAction.setEnabled(false);
                        if (!InstallSelectedPackagesStep.this.myBackgroundAction.isBackgrounded()) {
                            for (RepoPackage p : preparedPackages.keySet()) {
                                installer = (PackageOperation)preparedPackages.get(p);
                                if (installer.complete(this.myProgress)) continue;
                                failures.add(p);
                            }
                            break block20;
                        }
                        this.showPrepareCompleteNotification(preparedPackages.keySet());
                        if (failures.isEmpty()) break block21;
                    }
                    catch (Throwable throwable) {
                        if (!failures.isEmpty()) {
                            InstallSelectedPackagesStep.this.myLogger.logInfo("Failed packages:");
                            for (RepoPackage p : failures) {
                                InstallSelectedPackagesStep.this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                            }
                        }
                        Iterator iterator2 = LOGGER_LOCK;
                        synchronized (iterator2) {
                            InstallSelectedPackagesStep.this.myLogger = null;
                        }
                        throw throwable;
                    }
                    InstallSelectedPackagesStep.this.myLogger.logInfo("Failed packages:");
                    for (RepoPackage p : failures) {
                        InstallSelectedPackagesStep.this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                    }
                }
                iterator = LOGGER_LOCK;
                synchronized (iterator) {
                    InstallSelectedPackagesStep.this.myLogger = null;
                }
                return;
            }
            if (!failures.isEmpty()) {
                InstallSelectedPackagesStep.this.myLogger.logInfo("Failed packages:");
                for (RepoPackage p : failures) {
                    InstallSelectedPackagesStep.this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                }
            }
            iterator = LOGGER_LOCK;
            synchronized (iterator) {
                InstallSelectedPackagesStep.this.myLogger = null;
            }
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
            InstallSelectedPackagesStep.this.myRepoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (com.android.repository.api.ProgressIndicator)progress, null, StudioSettingsController.getInstance());
            UIUtil.invokeLaterIfNeeded(() -> {
                InstallSelectedPackagesStep.this.myProgressBar.setValue(100);
                InstallSelectedPackagesStep.this.myProgressOverallLabel.setText("");
                if (!failures.isEmpty()) {
                    InstallSelectedPackagesStep.this.myInstallFailed.set(true);
                    InstallSelectedPackagesStep.this.myProgressBar.setEnabled(false);
                } else {
                    InstallSelectedPackagesStep.this.myProgressDetailLabel.setText("Done");
                    InstallSelectedPackagesStep.checkForUpgrades(this.myRequestedPackages);
                }
                InstallSelectedPackagesStep.this.myInstallationFinished.set(true);
                VirtualFile sdkDir = LocalFileSystem.getInstance().findFileByIoFile(InstallSelectedPackagesStep.this.myRepoManager.getLocalPath());
                if (sdkDir != null) {
                    sdkDir.refresh(true, true);
                }
            });
        }

        @NotNull
        private PackageOperation getOrCreateInstaller(@NotNull RepoPackage p, @NotNull ProgressIndicator indicator) {
            PackageOperation op = InstallSelectedPackagesStep.this.myRepoManager.getInProgressInstallOperation(p);
            if (op == null || !(op instanceof Installer)) {
                InstallerFactory installerFactory = StudioSdkInstallerUtil.createInstallerFactory(p, InstallSelectedPackagesStep.this.mySdkHandler);
                op = installerFactory.createInstaller((RemotePackage)p, InstallSelectedPackagesStep.this.myRepoManager, (Downloader)new StudioDownloader(indicator), InstallSelectedPackagesStep.this.mySdkHandler.getFileOp());
            }
            return op;
        }

        @NotNull
        private PackageOperation getOrCreateUninstaller(@NotNull RepoPackage p) {
            PackageOperation op = InstallSelectedPackagesStep.this.myRepoManager.getInProgressInstallOperation(p);
            if (op == null || !(op instanceof Uninstaller) || op.getInstallStatus() == PackageOperation.InstallStatus.FAILED) {
                InstallerFactory installerFactory = StudioSdkInstallerUtil.createInstallerFactory(p, InstallSelectedPackagesStep.this.mySdkHandler);
                op = installerFactory.createUninstaller((LocalPackage)p, InstallSelectedPackagesStep.this.myRepoManager, InstallSelectedPackagesStep.this.mySdkHandler.getFileOp());
            }
            return op;
        }

        private void processPackage(@NotNull RepoPackage p, @NotNull PackageOperation op, @NotNull Map<RepoPackage, PackageOperation> preparedPackages, @NotNull List<RepoPackage> failures) {
            boolean success = false;
            try {
                success = op.prepare(this.myProgress);
            }
            catch (Exception e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn((Throwable)e);
            }
            if (success) {
                preparedPackages.put(p, op);
            } else {
                failures.add(p);
            }
        }

        private void showPrepareCompleteNotification(@NotNull Collection<RepoPackage> packages) {
            Project[] projectArray;
            NotificationListener.Adapter notificationListener = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    ModelWizardDialog dialogForPaths;
                    if ("install".equals(event.getDescription()) && (dialogForPaths = SdkQuickfixUtils.createDialogForPackages(null, InstallSelectedPackagesStep.this.myInstallRequests, InstallSelectedPackagesStep.this.myUninstallRequests, false)) != null) {
                        dialogForPaths.show();
                    }
                    notification.expire();
                }
            };
            NotificationGroup group = new NotificationGroup("SDK Installer", NotificationDisplayType.STICKY_BALLOON, false);
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length == 0) {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = null;
            } else {
                projectArray = openProjects;
            }
            Project[] openProjectsOrNull = projectArray;
            ApplicationManager.getApplication().invokeLater(() -> this.lambda$showPrepareCompleteNotification$492(openProjectsOrNull, packages, group, (NotificationListener)notificationListener), ModalityState.NON_MODAL, o -> {
                for (RepoPackage pack : packages) {
                    PackageOperation installer = InstallSelectedPackagesStep.this.myRepoManager.getInProgressInstallOperation(pack);
                    if (installer == null || installer.getInstallStatus() != PackageOperation.InstallStatus.PREPARED) continue;
                    return false;
                }
                return true;
            });
        }

        private /* synthetic */ void lambda$showPrepareCompleteNotification$492(Project[] projectArray, Collection collection, NotificationGroup notificationGroup, NotificationListener notificationListener) {
            for (Project p : projectArray) {
                String message;
                if (collection.size() == 1) {
                    RepoPackage pack = (RepoPackage)collection.iterator().next();
                    PackageOperation op = InstallSelectedPackagesStep.this.myRepoManager.getInProgressInstallOperation(pack);
                    String opName = op == null || op instanceof Installer ? "Install" : "Uninstall";
                    message = String.format("%1$sation of '%2$s' is ready to continue<br/><a href=\"install\">%1$s Now</a>", opName, pack.getDisplayName());
                } else {
                    message = collection.size() + " packages are ready to install or uninstall<br/><a href=\"install\">Continue</a>";
                }
                notificationGroup.createNotification("SDK Install", message, NotificationType.INFORMATION, notificationListener).notify(p);
            }
        }
    }
}

