/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.progress;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProgressRunner
implements ProgressRunner {
    private final boolean myInvokeInUiThread;
    private boolean myModal;
    private final boolean myBackgroundable;
    private final boolean myCancellable;
    private final Project myProject;
    private final String myProgressTitle;

    public StudioProgressRunner(boolean modal, boolean backgroundable, boolean cancellable, String progressTitle, boolean invokeInUiThread, @Nullable Project project) {
        this.myModal = modal;
        this.myBackgroundable = backgroundable;
        this.myCancellable = cancellable;
        this.myProject = project;
        this.myProgressTitle = progressTitle;
        this.myInvokeInUiThread = invokeInUiThread;
    }

    public void runAsyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean hasOpenProjects;
                Task.Backgroundable task = new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable, new PerformInBackgroundOption(){

                    public boolean shouldStartInBackground() {
                        return !StudioProgressRunner.this.myModal;
                    }

                    public void processSentToBackground() {
                    }
                }){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }

                    public boolean isConditionalModal() {
                        return true;
                    }
                };
                boolean bl = hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
                if (hasOpenProjects) {
                    ProgressManager.getInstance().run((Task)task);
                } else {
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (com.intellij.openapi.progress.ProgressIndicator)new EmptyProgressIndicator());
                }
            }
        });
    }

    public void runSyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Object task = StudioProgressRunner.this.myModal ? new Task.Modal(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }
                } : new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        });
    }

    public void runSyncWithoutProgress(@NotNull Runnable r) {
        if (this.myInvokeInUiThread) {
            ApplicationManager.getApplication().invokeAndWait(r, ModalityState.any());
        } else {
            r.run();
        }
    }
}

