/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkMerger {
    private static final Logger LOG = Logger.getInstance(SdkMerger.class);

    public static void mergeSdks(@NotNull File srcDir, @NotNull File destDir, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        Collection<MergeablePackage> packages = SdkMerger.compareSdks(srcDir, destDir, indicator);
        int numPackages = packages.size();
        int i = 0;
        for (MergeablePackage pkg : packages) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction((double)i++ / (double)numPackages);
                indicator.setText(String.format("Copying SDK package %1s", pkg.srcPkg.getPath()));
            }
            if (pkg.destPkg != null) {
                File destPkgDir = pkg.destPkg.getLocation();
                try {
                    FileUtil.delete((File)destPkgDir);
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed to delete destination directory " + destPkgDir.getPath(), (Throwable)e);
                }
            }
            try {
                FileUtil.copyDir((File)pkg.srcPkg.getLocation(), (File)new File(pkg.destLocation, pkg.srcPkg.getPath().replace(';', File.separatorChar)));
            }
            catch (IOException e) {
                LOG.error("Unable to copy package " + pkg.srcPkg.getPath(), (Throwable)e);
            }
        }
        if (indicator != null) {
            indicator.setFraction(1.0);
        }
        ProgressIndicator repoProgress = SdkMerger.getRepoProgress(indicator);
        AndroidSdkHandler.getInstance((File)destDir).getSdkManager(repoProgress).loadSynchronously(0L, repoProgress, null, null);
    }

    @NotNull
    public static ProgressIndicator getRepoProgress(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        Object repoProgress = indicator == null ? new StudioLoggerProgressIndicator(SdkMerger.class) : new RepoProgressIndicatorAdapter(indicator);
        return repoProgress;
    }

    public static boolean hasMergeableContent(@NotNull File srcDir, @NotNull File destDir) {
        return !SdkMerger.compareSdks(srcDir, destDir, null).isEmpty();
    }

    @NotNull
    private static Collection<MergeablePackage> compareSdks(@NotNull File srcDir, @NotNull File destDir, @Nullable com.intellij.openapi.progress.ProgressIndicator progress) {
        ProgressIndicator repoProgress = SdkMerger.getRepoProgress(progress);
        ArrayList results = Lists.newArrayList();
        AndroidSdkHandler srcHandler = AndroidSdkHandler.getInstance((File)srcDir);
        AndroidSdkHandler destHandler = AndroidSdkHandler.getInstance((File)destDir);
        Map srcPackages = srcHandler.getSdkManager(repoProgress).getPackages().getLocalPackages();
        Map destPackages = destHandler.getSdkManager(repoProgress).getPackages().getLocalPackages();
        for (LocalPackage srcPkg : srcPackages.values()) {
            LocalPackage destPkg = (LocalPackage)destPackages.get(srcPkg.getPath());
            if (destPkg != null) {
                if (srcPkg.getVersion().compareTo(destPkg.getVersion()) <= 0) continue;
                results.add(new MergeablePackage(srcPkg, destPkg, destDir));
                continue;
            }
            results.add(new MergeablePackage(srcPkg, null, destDir));
        }
        return results;
    }

    private static class MergeablePackage {
        @NotNull
        private final LocalPackage srcPkg;
        @Nullable
        private final LocalPackage destPkg;
        @NotNull
        private final File destLocation;

        private MergeablePackage(@NotNull LocalPackage srcPkg, @Nullable LocalPackage destPkg, @NotNull File destLocation) {
            this.srcPkg = srcPkg;
            this.destPkg = destPkg;
            this.destLocation = destLocation;
        }
    }
}

