/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SplitApkDeployTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;

    public SplitApkDeployTask(Project project, InstantRunContext context) {
        this.myProject = project;
        this.myInstantRunContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Installing APKs";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        InstantRunBuildInfo buildInfo = this.myInstantRunContext.getInstantRunBuildInfo();
        assert (buildInfo != null);
        List artifacts = buildInfo.getArtifacts();
        ArrayList installOptions = Lists.newArrayList();
        if (!buildInfo.hasMainApk()) {
            installOptions.add("-p");
            installOptions.add(this.myInstantRunContext.getApplicationId());
        }
        ArrayList apks = Lists.newArrayListWithExpectedSize((int)artifacts.size());
        for (InstantRunArtifact artifact : artifacts) {
            if (artifact.type != InstantRunArtifactType.SPLIT_MAIN && artifact.type != InstantRunArtifactType.SPLIT) continue;
            apks.add(artifact.file);
        }
        String cmd = SplitApkDeployTask.getAdbInstallCommand(apks, installOptions);
        printer.stdout(cmd);
        InstantRunManager.LOG.info(cmd);
        try {
            device.installPackages((List)apks, true, (List)installOptions, 5L, TimeUnit.MINUTES);
            printer.stdout("Split APKs installed");
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.SPLITAPK, this.myInstantRunContext.getBuildSelection().why, device);
            return true;
        }
        catch (InstallException e) {
            launchStatus.terminateLaunch("Error installing split apks: " + (Object)((Object)e));
            return false;
        }
    }

    @NotNull
    private static String getAdbInstallCommand(@NotNull List<File> apks, @NotNull List<String> installOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append("$ adb install-multiple -r ");
        if (!installOptions.isEmpty()) {
            sb.append(Joiner.on((char)' ').join(installOptions));
            sb.append(' ');
        }
        for (File f : apks) {
            sb.append(f.getPath());
            sb.append(' ');
        }
        return sb.toString();
    }
}

