/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.editors.gfxtrace.GfxTracer;
import com.android.tools.idea.editors.gfxtrace.actions.GfxTraceCaptureAction;
import com.android.tools.idea.editors.gfxtrace.forms.TraceDialog;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowId;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GapidTraceTask
implements LaunchTask {
    private static final NotificationGroup DEBUG_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"GPU Trace", (String)ToolWindowId.DEBUG);
    private static final String NOTIFICATION_DEBUG_TITLE = "Cannot trace while debugging";
    private static final String NOTIFICATION_DEBUG_MESSAGE = "Cannot capture a graphics trace while debugging the application. Tracing has been disabled for this run.";
    private final AndroidRunConfigurationBase myConfiguration;
    private final String myApplicationId;

    public GapidTraceTask(@NotNull AndroidRunConfigurationBase configuration, @NotNull String applicationId) {
        this.myConfiguration = configuration;
        this.myApplicationId = applicationId;
    }

    public static boolean checkIfOkToTrace(@Nullable Project project, @NotNull LaunchOptions launchOptions) {
        if (launchOptions.isDebug()) {
            DEBUG_NOTIFICATION_GROUP.createNotification(NOTIFICATION_DEBUG_TITLE, NOTIFICATION_DEBUG_MESSAGE, NotificationType.WARNING, null).notify(project);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Starts listening for a GPU trace";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public boolean perform(final @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final TraceDialog dialog = new TraceDialog();
                dialog.setListener(new TraceDialog.Listener(){
                    private GfxTracer myTracer = null;

                    @Override
                    public void onStartTrace(@NotNull String name) {
                        GfxTracer.Options options = GfxTracer.Options.fromRunConfiguration((RunConfiguration)GapidTraceTask.this.myConfiguration);
                        options.myTraceName = name;
                        this.myTracer = GfxTracer.listen(GapidTraceTask.this.myConfiguration.getProject(), device, GapidTraceTask.this.myApplicationId, options, GfxTraceCaptureAction.bindListener(dialog));
                    }

                    @Override
                    public void onStopTrace() {
                        this.myTracer.stop();
                    }

                    @Override
                    public void onCancelTrace() {
                    }
                });
                dialog.setLocationRelativeTo(JOptionPane.getRootFrame());
                dialog.setDefaultName(CaptureService.getInstance(GapidTraceTask.this.myConfiguration.getProject()).getSuggestedName(device.getClient(GapidTraceTask.this.myApplicationId)));
                dialog.setVisible(true);
            }
        });
        return true;
    }
}

