/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DexDeployTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;

    public DexDeployTask(@NotNull Project project, @NotNull InstantRunContext context) {
        this.myProject = project;
        this.myInstantRunContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Installing restart patches";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        try {
            InstantRunManager manager = InstantRunManager.get(this.myProject);
            manager.pushArtifacts(device, this.myInstantRunContext, UpdateMode.HOT_SWAP);
            printer.stdout("Cold swapped changes.");
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.DEX, this.myInstantRunContext.getBuildSelection().why, device);
            return true;
        }
        catch (InstantRunPushFailedException | IOException e) {
            launchStatus.terminateLaunch("Error installing cold swap patches: " + e);
            InstantRunManager.LOG.warn("Failed to push dex files: ", e);
            return false;
        }
    }
}

