/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectDebuggerTask
implements DebugConnectorTask {
    private static final int POLL_TIMEOUT = 15;
    private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
    @NotNull
    private final Set<String> myApplicationIds;
    @NotNull
    protected final AndroidDebugger myDebugger;
    @NotNull
    protected final Project myProject;

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project) {
        this.myApplicationIds = applicationIds;
        this.myDebugger = debugger;
        this.myProject = project;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Connecting Debugger";
    }

    @Override
    public int getDuration() {
        return 10;
    }

    @Override
    public ProcessHandler perform(final @NotNull LaunchInfo launchInfo, @NotNull IDevice device, final @NotNull ProcessHandlerLaunchStatus state, final @NotNull ProcessHandlerConsolePrinter printer) {
        this.logUnsupportedBreakpoints(device.getVersion(), printer);
        final Client client = this.waitForClient(device, state, printer);
        if (client == null) {
            return null;
        }
        return (ProcessHandler)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<ProcessHandler>(){

            public ProcessHandler compute() {
                return ConnectDebuggerTask.this.launchDebugger(launchInfo, client, state, printer);
            }
        });
    }

    private void logUnsupportedBreakpoints(@NotNull AndroidVersion version, final @NotNull ConsolePrinter printer) {
        final HashSet allBpTypes = Sets.newHashSet();
        for (AndroidDebugger androidDebugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            allBpTypes.addAll(androidDebugger.getSupportedBreakpointTypes(this.myProject, version));
        }
        allBpTypes.removeAll(this.myDebugger.getSupportedBreakpointTypes(this.myProject, version));
        if (allBpTypes.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                XBreakpointManager bpManager = XDebuggerManager.getInstance((Project)ConnectDebuggerTask.this.myProject).getBreakpointManager();
                for (XBreakpointType bpType : allBpTypes) {
                    Collection bps = bpManager.getBreakpoints(bpType);
                    if (bps.isEmpty()) continue;
                    String warnMsg = String.format("The currently selected %1$s debugger doesn't support breakpoints of type '%2$s'. As a result, these breakpoints will not be hit.\nThe debugger selection can be modified in the run configuration dialog.", ConnectDebuggerTask.this.myDebugger.getDisplayName(), bpType.getTitle());
                    printer.stderr(warnMsg);
                    Logger.getInstance(ConnectDebuggerTask.class).info(warnMsg);
                    return;
                }
            }
        });
    }

    @Nullable
    protected Client waitForClient(@NotNull IDevice device, @NotNull LaunchStatus state, @NotNull ConsolePrinter printer) {
        for (int i = 0; i < 15; ++i) {
            if (state.isLaunchTerminated()) {
                return null;
            }
            if (!device.isOnline()) {
                printer.stderr("Device is offline");
                return null;
            }
            block6: for (String name : this.myApplicationIds) {
                Client client = device.getClient(name);
                if (client == null) {
                    printer.stdout("Waiting for application to come online: " + Joiner.on((String)" | ").join(this.myApplicationIds));
                    continue;
                }
                printer.stdout("Connecting to " + name);
                ClientData.DebuggerStatus status = client.getClientData().getDebuggerConnectionStatus();
                switch (status) {
                    case ERROR: {
                        String message = String.format(Locale.US, "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application", client.getDebuggerListenPort());
                        printer.stderr(message);
                        return null;
                    }
                    case ATTACHED: {
                        printer.stderr("A debugger is already attached");
                        return null;
                    }
                    case WAITING: {
                        if (!this.isReadyForDebugging(client, printer)) continue block6;
                        return client;
                    }
                }
                printer.stderr("Waiting for application to start debug server");
            }
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)POLL_TIMEUNIT);
        }
        return null;
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        return true;
    }

    @Nullable
    public abstract ProcessHandler launchDebugger(@NotNull LaunchInfo var1, @NotNull Client var2, @NotNull ProcessHandlerLaunchStatus var3, @NotNull ProcessHandlerConsolePrinter var4);
}

