/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.run.editor.ProfilerState;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AndroidProfilersPanel {
    private static final boolean EXPERIMENTAL_ENABLED = System.getProperty("enable.experimental.profiling") != null;
    private JPanel myPanel;
    private JCheckBox myAdvancedProfilingCheckBox;
    private JCheckBox myGapidEnabled;
    private JCheckBox myGapidDisablePCS;

    public JComponent getComponent() {
        return this.myPanel;
    }

    AndroidProfilersPanel(Project project, ProfilerState state) {
        this.$$$setupUI$$$();
        this.myAdvancedProfilingCheckBox.setVisible(EXPERIMENTAL_ENABLED);
        this.myGapidEnabled.addChangeListener(e -> this.myGapidDisablePCS.setEnabled(this.myGapidEnabled.isSelected()));
        this.myGapidEnabled.addActionListener(e -> {
            if (!GfxTraceUtil.checkAndTryInstallGapidSdkComponent(project)) {
                this.myGapidEnabled.setSelected(false);
            }
        });
        this.resetFrom(state);
    }

    void resetFrom(ProfilerState state) {
        this.myAdvancedProfilingCheckBox.setSelected(state.ENABLE_ADVANCED_PROFILING);
        this.myGapidEnabled.setSelected(state.GAPID_ENABLED);
        this.myGapidDisablePCS.setSelected(state.GAPID_DISABLE_PCS);
        this.myGapidDisablePCS.setEnabled(state.GAPID_ENABLED);
        if (GapiPaths.isValid()) {
            this.myGapidEnabled.setToolTipText(null);
        } else {
            this.myGapidEnabled.setToolTipText("GPU debugger tools not installed or out of date.");
            this.myGapidEnabled.setSelected(false);
        }
    }

    void applyTo(ProfilerState state) {
        boolean enabled = System.getProperty("enable.experimental.profiling") != null;
        state.ENABLE_ADVANCED_PROFILING = this.myAdvancedProfilingCheckBox.isSelected() && enabled;
        state.GAPID_ENABLED = this.myGapidEnabled.isSelected();
        state.GAPID_DISABLE_PCS = this.myGapidDisablePCS.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdvancedProfilingCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable advanced profiling");
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Graphics Trace Options", 0, 0, null, null));
        this.myGapidEnabled = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Capture GPU Commands");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGapidDisablePCS = jCheckBox = new JCheckBox();
        jCheckBox.setText("Disable precompiled shaders and programs");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 1, null, new Dimension(10, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

