/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonGradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @Nullable
    private final String myArtifactName;

    public NonGradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @Nullable String artifactName) {
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myArtifactName = artifactName;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        String packageName = this.myApplicationIdProvider.getPackageName();
        HashMap depFacet2PackageName = new HashMap();
        NonGradleApkProvider.fillRuntimeAndTestDependencies(this.myFacet.getModule(), (Map<AndroidFacet, String>)depFacet2PackageName);
        NonGradleApkProvider.checkPackageNames((Map<AndroidFacet, String>)depFacet2PackageName, this.myFacet, packageName);
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        this.addApk(apkList, packageName, this.myFacet);
        for (AndroidFacet depFacet : depFacet2PackageName.keySet()) {
            this.addApk(apkList, (String)depFacet2PackageName.get((Object)depFacet), depFacet);
        }
        return apkList;
    }

    private void addApk(@NotNull List<ApkInfo> apkList, @NotNull String packageName, @NotNull AndroidFacet facet) throws ApkProvisionException {
        String localPath;
        Module module = facet.getModule();
        if (this.myArtifactName != null && this.myArtifactName.length() > 0) {
            Artifact artifact = ArtifactManager.getInstance((Project)facet.getModule().getProject()).findArtifact(this.myArtifactName);
            if (artifact == null) {
                throw new ApkProvisionException("ERROR: cannot find artifact \"" + this.myArtifactName + '\"');
            }
            if (!AndroidArtifactUtil.isRelatedArtifact(artifact, facet.getModule())) {
                throw new ApkProvisionException("ERROR: artifact \"" + this.myArtifactName + "\" doesn't contain packaged module \"" + facet.getModule().getName() + '\"');
            }
            String artifactOutPath = artifact.getOutputFilePath();
            if (artifactOutPath == null || artifactOutPath.length() == 0) {
                throw new ApkProvisionException("ERROR: output path is not specified for artifact \"" + this.myArtifactName + '\"');
            }
            localPath = FileUtil.toSystemDependentName((String)artifactOutPath);
        } else {
            localPath = AndroidRootUtil.getApkPath(facet);
        }
        if (localPath == null) {
            throw new ApkProvisionException("ERROR: APK path is not specified for module \"" + module.getName() + '\"');
        }
        apkList.add(new ApkInfo(new File(localPath), packageName));
    }

    private static void fillRuntimeAndTestDependencies(@NotNull Module module, @NotNull Map<AndroidFacet, String> module2PackageName) throws ApkProvisionException {
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            AndroidFacet depFacet;
            ModuleOrderEntry moduleOrderEntry;
            Module depModule;
            if (!(entry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || module2PackageName.containsKey((Object)depFacet) || depFacet.isLibraryProject()) continue;
            String packageName = ApkProviderUtil.computePackageName(depFacet);
            module2PackageName.put(depFacet, packageName);
            NonGradleApkProvider.fillRuntimeAndTestDependencies(depModule, module2PackageName);
        }
    }

    private static void checkPackageNames(@NotNull Map<AndroidFacet, String> additionalFacet2PackageName, @NotNull AndroidFacet facet, @NotNull String mainPackageName) throws ApkProvisionException {
        HashMap packageName2ModuleNames = new HashMap();
        packageName2ModuleNames.put(mainPackageName, new ArrayList<String>(Arrays.asList(facet.getModule().getName())));
        for (Map.Entry<AndroidFacet, String> entry : additionalFacet2PackageName.entrySet()) {
            String moduleName = entry.getKey().getModule().getName();
            String packageName = entry.getValue();
            ArrayList<String> list = (ArrayList<String>)packageName2ModuleNames.get(packageName);
            if (list == null) {
                list = new ArrayList<String>();
                packageName2ModuleNames.put(packageName, list);
            }
            list.add(moduleName);
        }
        StringBuilder messageBuilder = new StringBuilder("Applications have the same package name ");
        boolean fail = false;
        for (Map.Entry entry : packageName2ModuleNames.entrySet()) {
            String packageName = (String)entry.getKey();
            List moduleNames = (List)entry.getValue();
            if (moduleNames.size() <= 1) continue;
            fail = true;
            messageBuilder.append(packageName).append(":\n    ");
            Iterator it = moduleNames.iterator();
            while (it.hasNext()) {
                String moduleName = (String)it.next();
                messageBuilder.append(moduleName);
                if (!it.hasNext()) continue;
                messageBuilder.append(", ");
            }
            messageBuilder.append("\n");
        }
        if (fail) {
            throw new ApkProvisionException(messageBuilder.toString());
        }
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        return ImmutableList.of();
    }
}

