/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @NotNull
    private final LaunchInfo myLaunchInfo;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @Nullable
    private String myError;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @NotNull LaunchInfo launchInfo, @NotNull ProcessHandler processHandler, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider) {
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myLaunchInfo = launchInfo;
        this.myProcessHandler = processHandler;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setText(this.getTitle());
        indicator.setIndeterminate(false);
        ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus(this.myProcessHandler);
        ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter(this.myProcessHandler);
        List<ListenableFuture<IDevice>> listenableDeviceFutures = this.myDeviceFutures.get();
        AndroidVersion androidVersion = this.myDeviceFutures.getDevices().size() == 1 ? this.myDeviceFutures.getDevices().get(0).getVersion() : null;
        DebugConnectorTask debugSessionTask = this.myLaunchTasksProvider.getConnectDebuggerTask(launchStatus, androidVersion);
        if (debugSessionTask != null && listenableDeviceFutures.size() != 1) {
            launchStatus.terminateLaunch("Cannot launch a debug session on more than 1 device.");
        }
        if (debugSessionTask != null) {
            AndroidProcessText.attach(this.myProcessHandler);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        consolePrinter.stdout("\n" + dateFormat.format(new Date()) + ": Launching " + this.myConfigName);
        for (ListenableFuture<IDevice> deviceFuture : listenableDeviceFutures) {
            indicator.setText("Waiting for target device to come online");
            IDevice device = LaunchTaskRunner.waitForDevice(deviceFuture, indicator, launchStatus);
            if (device == null) {
                return;
            }
            List<LaunchTask> launchTasks = null;
            try {
                launchTasks = this.myLaunchTasksProvider.getTasks(device, launchStatus, consolePrinter);
            }
            catch (com.intellij.execution.ExecutionException e) {
                launchStatus.terminateLaunch(e.getMessage());
                return;
            }
            int totalDuration = listenableDeviceFutures.size() * LaunchTaskRunner.getTotalDuration(launchTasks, debugSessionTask);
            int elapsed = 0;
            for (LaunchTask task : launchTasks) {
                indicator.setText(task.getDescription());
                if (!task.perform(device, launchStatus, consolePrinter)) {
                    this.myError = "Error " + task.getDescription();
                    launchStatus.terminateLaunch("Error while " + task.getDescription());
                    return;
                }
                indicator.setFraction((double)(elapsed += task.getDuration()) / (double)totalDuration);
                if (indicator.isCanceled()) {
                    launchStatus.terminateLaunch("User cancelled launch");
                    return;
                }
                if (!launchStatus.isLaunchTerminated()) continue;
                return;
            }
            if (debugSessionTask != null) {
                debugSessionTask.perform(this.myLaunchInfo, device, launchStatus, consolePrinter);
                continue;
            }
            if (!this.myLaunchTasksProvider.createsNewProcess() || !(this.myProcessHandler instanceof AndroidProcessHandler)) continue;
            ((AndroidProcessHandler)this.myProcessHandler).addTargetDevice(device);
        }
    }

    public void onSuccess() {
        if (this.myError == null) {
            return;
        }
        LaunchUtils.showNotification(this.myProject, this.myLaunchInfo.executor, this.myConfigName, this.myError, NotificationType.ERROR);
    }

    @Nullable
    private static IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus) {
        do {
            try {
                return (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device");
                return null;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage());
                return null;
            }
            if (!indicator.isCanceled()) continue;
            launchStatus.terminateLaunch("User cancelled launch");
            return null;
        } while (!launchStatus.isLaunchTerminated());
        return null;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, @Nullable DebugConnectorTask debugSessionTask) {
        int total = 0;
        for (LaunchTask task : launchTasks) {
            total += task.getDuration();
        }
        if (debugSessionTask != null) {
            total += debugSessionTask.getDuration();
        }
        return total;
    }
}

