/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.DeviceStateCache;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledApkCache
implements Disposable {
    private final DeviceStateCache<CacheData> myCache = new DeviceStateCache(this);
    private String myDiagnosticOutput;

    public void dispose() {
    }

    public boolean isInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName, @Nullable Integer userId) throws IOException {
        CacheData state = this.myCache.get(device, pkgName);
        if (state == null) {
            return false;
        }
        InstallState currentState = this.getInstallState(device, pkgName);
        return currentState != null && ((CacheData)state).installState.lastUpdateTime.equals(currentState.lastUpdateTime) && state.hash.equals((Object)InstalledApkCache.hash(apk)) && (userId == null || currentState.users.contains(userId));
    }

    public void setInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName) throws IOException {
        InstallState installState = this.getInstallState(device, pkgName);
        if (installState == null) {
            String msg = String.format("Unexpected error: package manager reports that package %1$s has not been installed: %2$s", pkgName, StringUtil.notNullize((String)this.myDiagnosticOutput));
            Logger.getInstance(InstalledApkCache.class).warn(msg);
            return;
        }
        this.myCache.put(device, pkgName, new CacheData(installState, InstalledApkCache.hash(apk)));
    }

    @NotNull
    private static HashCode hash(@NotNull File apk) throws IOException {
        return Files.hash((File)apk, (HashFunction)Hashing.goodFastHash((int)32));
    }

    void deviceDisconnected(IDevice device) {
        this.myCache.deviceDisconnected(device);
    }

    @Nullable
    public InstallState getInstallState(@NotNull IDevice device, @NotNull String pkgName) {
        String output;
        boolean deviceHasPackage = false;
        this.myDiagnosticOutput = null;
        try {
            output = this.executeShellCommand(device, "dumpsys package " + pkgName, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.myDiagnosticOutput = String.format("Error executing 'dumpsys package %1$s:\n%2$s'", pkgName, e.getMessage());
            return null;
        }
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Package [")) continue;
            int startIndex = line.indexOf(91);
            int endIndex = line.indexOf(93);
            if (startIndex <= 0 || endIndex <= startIndex) break;
            deviceHasPackage = pkgName.equals(line.substring(startIndex + 1, endIndex));
            break;
        }
        if (!deviceHasPackage) {
            this.myDiagnosticOutput = String.format("Expected string 'Package [%1$s]' not found in output: %2$s", pkgName, output);
            return null;
        }
        String lastUpdateTime = "";
        HashSet users = Sets.newHashSet();
        for (String line : lines) {
            if ((line = line.trim()).startsWith("lastUpdateTime")) {
                lastUpdateTime = line;
            }
            if (!line.startsWith("User ") || !line.contains("installed=true")) continue;
            int endIndex = line.indexOf(":");
            try {
                users.add(Integer.parseInt(line.substring("User ".length(), endIndex)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new InstallState(lastUpdateTime, users);
    }

    protected String executeShellCommand(@NotNull IDevice device, @NotNull String cmd, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        device.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        latch.await(timeout, timeUnit);
        return receiver.getOutput();
    }

    private static class CacheData {
        @NotNull
        private final InstallState installState;
        @NotNull
        private final HashCode hash;

        private CacheData(@NotNull InstallState installState, @NotNull HashCode hash) {
            this.installState = installState;
            this.hash = hash;
        }
    }

    public static class InstallState {
        @NotNull
        public final String lastUpdateTime;
        @NotNull
        public final Set<Integer> users;

        public InstallState(@NotNull String lastUpdateTime, @NotNull Set<Integer> users) {
            this.lastUpdateTime = lastUpdateTime;
            this.users = users;
        }
    }
}

