/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class GradleApplicationIdProvider
implements ApplicationIdProvider {
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        return ApkProviderUtil.computePackageName(this.myFacet);
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }
}

