/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ValidationError;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    private static final Logger LOG = Logger.getInstance(GradleApkProvider.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        if (androidModel == null) {
            LOG.warn("Android model is null. Sync might have failed");
            return Collections.emptyList();
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        ArrayList apkList = Lists.newArrayList();
        if (!androidModel.getAndroidProject().isLibrary()) {
            File apk = GradleApkProvider.getApk(selectedVariant, device);
            apkList.add(new ApkInfo(apk, this.myApplicationIdProvider.getPackageName()));
        }
        if (this.myTest) {
            AndroidArtifact testArtifactInfo = androidModel.getAndroidTestArtifactInSelectedVariant();
            if (testArtifactInfo != null) {
                AndroidArtifactOutput output = GradleUtil.getOutput(testArtifactInfo);
                File testApk = output.getMainOutputFile().getOutputFile();
                String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                assert (testPackageName != null);
                apkList.add(new ApkInfo(testApk, testPackageName));
            }
            if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                apkList.addAll(0, this.getTargetedApks(selectedVariant, device));
            }
        }
        return apkList;
    }

    @NotNull
    private static File getApk(@NotNull Variant variant, @NotNull IDevice device) throws ApkProvisionException {
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        ArrayList outputs = Lists.newArrayList((Iterable)mainArtifact.getOutputs());
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List abis = device.getAbis();
        int density = device.getDensity();
        Set variantAbiFilters = mainArtifact.getAbiFilters();
        List apkFiles = SplitOutputMatcher.computeBestOutput((List)outputs, (Collection)variantAbiFilters, (int)density, (List)abis);
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant.getDisplayName(), outputs.size(), density, Joiner.on((String)", ").join((Iterable)abis));
            throw new ApkProvisionException(message);
        }
        return ((OutputFile)apkFiles.get(0)).getOutputFile();
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull Variant selectedVariant, @NotNull IDevice device) throws ApkProvisionException {
        ArrayList targetedApks = Lists.newArrayList();
        for (TestedTargetVariant testedVariant : GradleApkProvider.getTestedTargetVariants(selectedVariant)) {
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> GradleUtil.findModuleByGradlePath(this.myFacet.getModule().getProject(), testedVariant.getTargetProjectPath()));
            assert (targetModule != null);
            AndroidFacet targetFacet = AndroidFacet.getInstance(targetModule);
            if (targetFacet == null) {
                LOG.warn("Please install tested apk manually.");
                continue;
            }
            AndroidGradleModel targetAndroidModel = AndroidGradleModel.get(targetFacet);
            if (targetAndroidModel == null) {
                LOG.warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            Variant targetVariant = targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                LOG.warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = GradleApkProvider.getApk(targetVariant, device);
            targetedApks.add(new ApkInfo(targetApk, targetVariant.getMergedFlavor().getApplicationId()));
        }
        return targetedApks;
    }

    @NotNull
    private static Collection<TestedTargetVariant> getTestedTargetVariants(@NotNull Variant variant) {
        try {
            return variant.getTestedTargetVariants();
        }
        catch (UnsupportedMethodException e) {
            Logger.getInstance(GradleApkProvider.class).warn("Method 'getTestedTargetVariants' not found", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(this.myFacet);
        assert (androidGradleModel != null);
        if (androidGradleModel.getMainArtifact().isSigned()) {
            return ImmutableList.of();
        }
        AndroidArtifactOutput output = GradleUtil.getOutput(androidGradleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidGradleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = new Runnable(){

            @Override
            public void run() {
                Module module = GradleApkProvider.this.myFacet.getModule();
                ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
                if (service instanceof AndroidProjectSettingsService) {
                    ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
                } else {
                    service.openModuleSettings(module);
                }
            }
        };
        return ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
    }
}

