/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExternalToolRunner {
    private final Project myProject;
    private final String myTitle;
    private final GeneralCommandLine myCommandLine;
    private ProcessHandler myProcessHandler;

    public ExternalToolRunner(@NotNull Project project, @NotNull String consoleTitle, @NotNull GeneralCommandLine commandLine) {
        this.myProject = project;
        this.myTitle = consoleTitle;
        this.myCommandLine = commandLine;
    }

    public ProcessHandler start() throws ExecutionException {
        Process process = this.createProcess();
        this.myProcessHandler = this.createProcessHandler(process, this.myCommandLine);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ExternalToolRunner.this.initConsoleUi();
            }
        });
        return this.myProcessHandler;
    }

    @NotNull
    protected Process createProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    @NotNull
    protected ProcessHandler createProcessHandler(Process process, @NotNull GeneralCommandLine commandLine) {
        return new OSProcessHandler(process, commandLine.getCommandLineString());
    }

    protected ConsoleView initConsoleUi() {
        ConsoleView consoleView = this.createConsoleView();
        consoleView.print(this.myCommandLine.getCommandLineString() + '\n', ConsoleViewContentType.USER_INPUT);
        consoleView.attachToProcess(this.myProcessHandler);
        JPanel panel = new JPanel(new BorderLayout());
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        panel.add((Component)actionToolbar.getComponent(), "West");
        panel.add((Component)consoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel);
        toolbarActions.addAll(consoleView.createConsoleActions());
        this.fillToolBarActions(toolbarActions);
        panel.updateUI();
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        RunContentDescriptor contentDescriptor = new RunContentDescriptor((ExecutionConsole)consoleView, this.myProcessHandler, (JComponent)panel, this.myTitle);
        this.showConsole(defaultExecutor, contentDescriptor);
        this.myProcessHandler.addProcessListener((ProcessListener)new ConsoleListener(this.myProject, defaultExecutor, this.myProcessHandler));
        this.myProcessHandler.startNotify();
        return consoleView;
    }

    protected ConsoleView createConsoleView() {
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        builder.setViewer(true);
        return builder.getConsole();
    }

    protected void fillToolBarActions(DefaultActionGroup toolbarActions) {
        toolbarActions.addAction(ActionManager.getInstance().getAction("Stop"));
    }

    protected void showConsole(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
    }

    public static class ProcessOutputCollector
    extends ProcessAdapter {
        private final StringBuilder sb = new StringBuilder();

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            this.sb.append(event.getText());
        }

        public String getText() {
            return this.sb.toString();
        }
    }

    private static class ConsoleListener
    extends ProcessAdapter {
        private final Project myProject;
        private final Executor myExecutor;
        private final ProcessHandler myProcessHandler;

        public ConsoleListener(@NotNull Project project, @NotNull Executor executor, @NotNull ProcessHandler processHandler) {
            this.myProject = project;
            this.myExecutor = executor;
            this.myProcessHandler = processHandler;
        }

        public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            this.myProcessHandler.removeProcessListener((ProcessListener)this);
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            boolean hasError;
            String text = event.getText();
            boolean bl = hasError = text != null && text.toLowerCase(Locale.US).contains("error");
            if (hasError || ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(this.myExecutor, this.myProcessHandler);
            }
        }
    }
}

